/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.actions;

import java.util.Iterator;
import name.herlin.command.CommandException;
import net.sourceforge.pmd.cpd.CSVRenderer;
import net.sourceforge.pmd.cpd.LanguageFactory;
import net.sourceforge.pmd.cpd.Renderer;
import net.sourceforge.pmd.cpd.SimpleRenderer;
import net.sourceforge.pmd.cpd.XMLRenderer;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.DetectCutAndPasteCmd;
import net.sourceforge.pmd.eclipse.ui.dialogs.CPDCheckDialog;
import net.sourceforge.pmd.eclipse.ui.views.CPDView;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;

public class CPDCheckProjectAction
implements IObjectActionDelegate {
    private static final Logger log;
    private IWorkbenchPart targetPart;
    private static final String XML_KEY = "XML";
    private static final String SIMPLE_KEY = "Simple Text";
    private static final String CSV_KEY = "CSV";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.pmd.eclipse.ui.actions.CPDCheckProjectAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
        this.targetPart = iWorkbenchPart;
    }

    public void run(IAction iAction) {
        String[] stringArray;
        String[] stringArray2;
        IWorkbenchPartSite iWorkbenchPartSite = this.targetPart.getSite();
        ISelection iSelection = iWorkbenchPartSite.getSelectionProvider().getSelection();
        Shell shell = iWorkbenchPartSite.getShell();
        CPDCheckDialog cPDCheckDialog = new CPDCheckDialog(shell, stringArray2 = LanguageFactory.supportedLanguages, stringArray = new String[]{SIMPLE_KEY, XML_KEY, CSV_KEY});
        if (cPDCheckDialog.open() == 0 && iSelection instanceof IStructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)iSelection;
            Iterator iterator = structuredSelection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof IAdaptable) {
                    IProject iProject;
                    IAdaptable iAdaptable = (IAdaptable)e;
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IProject");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((iProject = (IProject)iAdaptable.getAdapter((Class)clazz)) == null) {
                        log.warn((Object)"The selected object cannot adapt to a project");
                        log.debug((Object)("   -> selected object : " + e));
                        continue;
                    }
                    this.detectCutAndPaste(iProject, cPDCheckDialog);
                    continue;
                }
                log.warn((Object)"The selected object is not adaptable");
                log.debug((Object)("   -> selected object : " + e));
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    private void detectCutAndPaste(IProject iProject, CPDCheckDialog cPDCheckDialog) {
        String string = cPDCheckDialog.getSelectedLanguage();
        int n = cPDCheckDialog.getTileSize();
        boolean bl = cPDCheckDialog.isCreateReportSelected();
        Renderer renderer = this.createRenderer(cPDCheckDialog.getSelectedFormat());
        String string2 = this.createFileName(cPDCheckDialog.getSelectedFormat());
        CPDView cPDView = this.showView();
        try {
            DetectCutAndPasteCmd detectCutAndPasteCmd = new DetectCutAndPasteCmd();
            detectCutAndPasteCmd.setProject(iProject);
            detectCutAndPasteCmd.setCreateReport(bl);
            detectCutAndPasteCmd.setLanguage(string);
            detectCutAndPasteCmd.setMinTileSize(n);
            detectCutAndPasteCmd.setRenderer(renderer);
            detectCutAndPasteCmd.setReportName(string2);
            detectCutAndPasteCmd.setUserInitiated(true);
            detectCutAndPasteCmd.addPropertyListener(cPDView);
            detectCutAndPasteCmd.performExecute();
        }
        catch (CommandException commandException) {
            PMDPlugin.getDefault().logError(this.getString("message.error.pmd_exception"), commandException);
        }
    }

    private CPDView showView() {
        CPDView cPDView = null;
        try {
            IWorkbenchPage iWorkbenchPage = this.targetPart.getSite().getPage();
            cPDView = (CPDView)iWorkbenchPage.showView("net.sourceforge.pmd.eclipse.ui.views.CPDView");
        }
        catch (PartInitException partInitException) {
            PMDPlugin.getDefault().logError(this.getString("message.error.view_exception"), partInitException);
        }
        return cPDView;
    }

    private Renderer createRenderer(String string) {
        XMLRenderer xMLRenderer = null;
        if (XML_KEY.equals(string)) {
            xMLRenderer = new XMLRenderer();
        } else if (SIMPLE_KEY.equals(string)) {
            xMLRenderer = new SimpleRenderer();
        } else if (CSV_KEY.equals(string)) {
            xMLRenderer = new CSVRenderer();
        }
        return xMLRenderer;
    }

    private String createFileName(String string) {
        String string2 = null;
        string2 = XML_KEY.equals(string) ? "cpd-report.xml" : (CSV_KEY.equals(string) ? "cpd-report.csv" : "cpd-report.txt");
        return string2;
    }

    private String getString(String string) {
        return PMDPlugin.getDefault().getStringTable().getString(string);
    }
}

