/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.dfa.IDataFlowNode;
import net.sourceforge.pmd.dfa.variableaccess.VariableAccess;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class DataflowGraph
extends Composite {
    private ArrayList nodes;
    private ArrayList paths;
    protected int nodeRadius = 12;
    protected int lineLength = 25;
    protected int rowHeight = 2 * this.nodeRadius + this.lineLength;
    protected Color bgColor;
    protected Color nodeColor;
    protected Color textColor;
    protected boolean marked;
    protected Color markColor;
    protected Color markColor2;
    protected Color markColor3;

    public DataflowGraph(Composite composite, SimpleNode simpleNode, int n, int n2, int n3) {
        super(composite, 0);
        if (simpleNode == null) {
            return;
        }
        this.nodeRadius = n;
        this.lineLength = n2;
        this.rowHeight = n3;
        this.nodes = new ArrayList();
        this.paths = new ArrayList();
        this.bgColor = new Color(null, 255, 255, 255);
        this.nodeColor = new Color(null, 192, 192, 192);
        this.textColor = new Color(null, 0, 0, 0);
        this.markColor = new Color(null, 192, 0, 0);
        this.markColor2 = new Color(null, 128, 0, 128);
        this.markColor3 = new Color(null, 0, 0, 96);
        this.setSize(composite.getSize());
        this.setBackground(this.bgColor);
        this.createDataflowGraph(simpleNode);
    }

    public void addMouseListener(final MouseListener mouseListener) {
        if (this.nodes != null) {
            Iterator iterator = this.nodes.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                final int n2 = n++;
                NodeCanvas nodeCanvas = (NodeCanvas)((Object)iterator.next());
                nodeCanvas.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDown(MouseEvent mouseEvent) {
                        mouseEvent.y += n2 * 49;
                        mouseListener.mouseDown(mouseEvent);
                    }
                });
            }
        }
        super.addMouseListener(mouseListener);
    }

    public void setGraphData(int n, int n2) {
        this.nodeRadius = n;
        this.lineLength = n2;
        this.redraw();
    }

    private void createDataflowGraph(SimpleNode simpleNode) {
        List list = simpleNode.getDataFlowNode().getFlow();
        int n = 0;
        while (n < list.size()) {
            IDataFlowNode iDataFlowNode = (IDataFlowNode)list.get(n);
            Point point = new Point((this.getSize().x - 2 * this.nodeRadius) / 2, n * this.rowHeight + this.lineLength / 2);
            NodeCanvas nodeCanvas = new NodeCanvas(this, iDataFlowNode, point, this.nodeRadius);
            this.nodes.add(nodeCanvas);
            List list2 = iDataFlowNode.getChildren();
            int n2 = 0;
            while (n2 < list2.size()) {
                IDataFlowNode iDataFlowNode2 = (IDataFlowNode)list2.get(n2);
                int n3 = (this.getSize().x - 2 * this.nodeRadius) / 2;
                int n4 = iDataFlowNode.getIndex() * this.rowHeight + this.lineLength / 2;
                int n5 = iDataFlowNode2.getIndex() * this.rowHeight + this.lineLength / 2;
                PathCanvas pathCanvas = new PathCanvas(this, iDataFlowNode.getIndex(), iDataFlowNode2.getIndex(), n3, n4, n5, this.nodeRadius);
                this.paths.add(pathCanvas);
                ++n2;
            }
            ++n;
        }
    }

    private NodeCanvas getNode(int n) {
        if (this.nodes == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < this.nodes.size()) {
            NodeCanvas nodeCanvas = (NodeCanvas)((Object)this.nodes.get(n2));
            if (nodeCanvas.getIndex() == n) {
                return nodeCanvas;
            }
            ++n2;
        }
        return null;
    }

    private PathCanvas getPath(int n, int n2) {
        if (this.paths == null) {
            return null;
        }
        int n3 = 0;
        while (n3 < this.paths.size()) {
            PathCanvas pathCanvas = (PathCanvas)this.paths.get(n3);
            if (pathCanvas.getIndex1() == n && pathCanvas.getIndex2() == n2) {
                return pathCanvas;
            }
            ++n3;
        }
        return null;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void demark() {
        PaintListener paintListener;
        int n = 0;
        while (n < this.nodes.size()) {
            paintListener = (NodeCanvas)((Object)this.nodes.get(n));
            paintListener.mark(false, null);
            ++n;
        }
        n = 0;
        while (n < this.paths.size()) {
            paintListener = (PathCanvas)this.paths.get(n);
            paintListener.mark(false, null);
            ++n;
        }
        this.redraw();
        this.marked = false;
    }

    public void markNode(int n) {
        NodeCanvas nodeCanvas = this.getNode(n);
        nodeCanvas.mark(true, this.markColor3);
    }

    public void markPath(int n, int n2, String string) {
        Object object;
        Object object2;
        PaintListener paintListener;
        if (this.nodes == null || this.paths == null) {
            return;
        }
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        ArrayList<IDataFlowNode> arrayList = new ArrayList<IDataFlowNode>();
        IDataFlowNode iDataFlowNode = null;
        int n4 = 0;
        while (n4 < this.nodes.size()) {
            paintListener = (NodeCanvas)((Object)this.nodes.get(n4));
            if (!paintListener.containsVariable(string)) {
                paintListener.mark(false, null);
            } else if (paintListener.getLine() == n) {
                paintListener.mark(true, this.markColor);
                arrayList.add(paintListener.getINode());
            } else if (paintListener.getLine() == n2) {
                paintListener.mark(true, this.markColor);
                iDataFlowNode = paintListener.getINode();
            } else {
                paintListener.mark(false, null);
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < this.paths.size()) {
            paintListener = (PathCanvas)this.paths.get(n4);
            paintListener.mark(false, null);
            ++n4;
        }
        ArrayList<PathCanvas> arrayList2 = new ArrayList<PathCanvas>();
        int n5 = 0;
        while (n5 < arrayList.size()) {
            object2 = (IDataFlowNode)arrayList.get(n5);
            object = this.findPath((IDataFlowNode)object2, iDataFlowNode, new ArrayList());
            if (object != null) {
                int n6 = 0;
                while (n6 < ((ArrayList)object).size()) {
                    PathCanvas pathCanvas = (PathCanvas)((ArrayList)object).get(n6);
                    if (!arrayList2.contains(pathCanvas)) {
                        arrayList2.add(pathCanvas);
                    }
                    ++n6;
                }
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < arrayList2.size()) {
            object2 = (PathCanvas)arrayList2.get(n5);
            ((PathCanvas)object2).mark(true, this.markColor);
            if (n5 < arrayList2.size() - 1 && !((NodeCanvas)((Object)(object = this.getNode(((PathCanvas)object2).getIndex2())))).isMarked()) {
                ((NodeCanvas)((Object)object)).mark(true, this.markColor2);
            }
            ++n5;
        }
        this.redraw();
        this.marked = true;
    }

    protected ArrayList findPath(IDataFlowNode iDataFlowNode, IDataFlowNode iDataFlowNode2, ArrayList arrayList) {
        if (iDataFlowNode.getChildren().contains(iDataFlowNode2)) {
            ArrayList<PathCanvas> arrayList2 = new ArrayList<PathCanvas>();
            PathCanvas pathCanvas = this.getPath(iDataFlowNode.getIndex(), iDataFlowNode2.getIndex());
            if (pathCanvas != null) {
                arrayList2.add(pathCanvas);
                return arrayList2;
            }
        } else {
            List list = iDataFlowNode.getChildren();
            int n = 0;
            while (n < list.size()) {
                IDataFlowNode iDataFlowNode3 = (IDataFlowNode)list.get(n);
                if (!arrayList.contains(iDataFlowNode3)) {
                    arrayList.add(iDataFlowNode3);
                    ArrayList arrayList3 = this.findPath(iDataFlowNode3, iDataFlowNode2, arrayList);
                    if (arrayList3 != null) {
                        PathCanvas pathCanvas = (PathCanvas)arrayList3.get(0);
                        PathCanvas pathCanvas2 = this.getPath(iDataFlowNode.getIndex(), pathCanvas.getIndex1());
                        if (pathCanvas2 != null) {
                            arrayList3.add(0, pathCanvas2);
                            return arrayList3;
                        }
                    }
                }
                ++n;
            }
        }
        return null;
    }

    private class NodeCanvas
    extends Canvas
    implements PaintListener {
        private IDataFlowNode node;
        private int radius;
        private Color bgColor;
        private Color nodeColor;
        private Color textColor;
        protected boolean marked;
        protected Color markColor;

        public NodeCanvas(Composite composite, IDataFlowNode iDataFlowNode, Point point, int n) {
            super(composite, 0);
            this.node = iDataFlowNode;
            this.radius = n;
            this.bgColor = new Color(null, 255, 255, 255);
            this.nodeColor = new Color(null, 128, 128, 128);
            this.textColor = new Color(null, 255, 255, 255);
            this.markColor = new Color(null, 192, 0, 0);
            this.setLocation(point);
            this.setSize(2 * this.radius, 2 * this.radius);
            this.setBackground(this.bgColor);
            this.addPaintListener(this);
        }

        public void setColors(Color color, Color color2, Color color3) {
            if (color != null) {
                this.bgColor = color;
                this.setBackground(this.bgColor);
            }
            this.nodeColor = color2;
            this.textColor = color3;
        }

        public int getLine() {
            return this.node.getLine();
        }

        public int getIndex() {
            return this.node.getIndex();
        }

        public boolean containsVariable(String string) {
            List list = this.node.getVariableAccess();
            if (list == null) {
                return false;
            }
            int n = 0;
            while (n < list.size()) {
                VariableAccess variableAccess = (VariableAccess)list.get(n);
                if (variableAccess.getVariableName().equalsIgnoreCase(string)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public IDataFlowNode getINode() {
            return this.node;
        }

        public boolean isMarked() {
            return this.marked;
        }

        public void paintControl(PaintEvent paintEvent) {
            if (this.marked) {
                paintEvent.gc.setBackground(this.markColor);
            } else {
                paintEvent.gc.setBackground(this.nodeColor);
            }
            paintEvent.gc.fillArc(0, 0, 2 * this.radius, 2 * this.radius, 0, 360);
            String string = String.valueOf(this.node.getIndex());
            int n = this.radius - 2 - 4 * (string.length() / 2);
            int n2 = this.radius / 2;
            paintEvent.gc.setForeground(this.textColor);
            paintEvent.gc.drawString(string, n, n2);
        }

        public void mark(boolean bl, Color color) {
            this.marked = bl;
            this.markColor = color;
            this.redraw();
        }
    }

    private class PathCanvas
    implements PaintListener {
        private int index1;
        private int index2;
        private int radius;
        private Rectangle bounds;
        private Color lineColor;
        private int arrowWidth;
        private int arrowHeight;
        protected boolean marked;
        protected Color markColor;

        public PathCanvas(Composite composite, int n, int n2, int n3, int n4, int n5, int n6) {
            this.index1 = n;
            this.index2 = n2;
            this.radius = n6;
            this.arrowWidth = 4;
            this.arrowHeight = 7;
            this.lineColor = new Color(null, 0, 0, 0);
            this.markColor = new Color(null, 192, 0, 0);
            this.bounds = this.calculateBounds(n3, n4, n5);
            composite.addPaintListener((PaintListener)this);
        }

        public int getIndex1() {
            return this.index1;
        }

        public int getIndex2() {
            return this.index2;
        }

        public void setColor(Color color) {
            this.lineColor = color;
        }

        private Rectangle calculateBounds(int n, int n2, int n3) {
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            if (this.index1 < this.index2) {
                if (this.index2 - this.index1 == 1) {
                    n4 = n + this.radius - this.arrowWidth;
                    n5 = n + this.radius + this.arrowWidth;
                    n6 = n2 + 2 * this.radius;
                    n7 = n3;
                } else if (this.index2 - this.index1 > 1) {
                    n6 = n2 + this.radius - 1;
                    n7 = n3 + this.radius;
                    int n8 = (this.index2 - this.index1) * 3 + 10;
                    n8 = (int)((double)n8 + Math.random() * 5.0);
                    n4 = n - n8;
                    n5 = n;
                }
            } else if (this.index1 - this.index2 == 1) {
                n4 = n + this.radius - this.arrowWidth;
                n5 = n + this.radius + this.arrowWidth;
                n6 = n3 + 2 * this.radius;
                n7 = n2;
            } else if (this.index1 - this.index2 > 1) {
                n6 = n3 + this.radius - 1;
                n7 = n2 + this.radius;
                int n9 = (this.index1 - this.index2) * 3 + 10;
                n9 = (int)((double)n9 + Math.random() * 5.0);
                n4 = n + 2 * this.radius;
                n5 = n + 2 * this.radius + n9;
            }
            return new Rectangle(n4, n6, n5, n7);
        }

        public void paintControl(PaintEvent paintEvent) {
            if (this.marked) {
                paintEvent.gc.setForeground(this.markColor);
                paintEvent.gc.setBackground(this.markColor);
            } else {
                paintEvent.gc.setForeground(this.lineColor);
                paintEvent.gc.setBackground(this.lineColor);
            }
            int n = this.bounds.width - this.bounds.x;
            if (this.index1 < this.index2) {
                if (this.index2 - this.index1 == 1) {
                    paintEvent.gc.drawLine(this.bounds.x + n / 2, this.bounds.y, this.bounds.x + n / 2, this.bounds.height);
                    paintEvent.gc.fillPolygon(new int[]{this.bounds.x, this.bounds.height - this.arrowHeight, this.bounds.width, this.bounds.height - this.arrowHeight, this.bounds.x + n / 2, this.bounds.height});
                } else if (this.index2 - this.index1 > 1) {
                    paintEvent.gc.drawPolyline(new int[]{this.bounds.x + n, this.bounds.y, this.bounds.x, this.bounds.y + n, this.bounds.x, this.bounds.height - n, this.bounds.width, this.bounds.height});
                    paintEvent.gc.fillPolygon(new int[]{this.bounds.width, this.bounds.height, this.bounds.width - this.arrowHeight - this.arrowWidth / 2 + 1, this.bounds.height - this.arrowWidth, this.bounds.width - this.arrowWidth, this.bounds.height - this.arrowHeight - this.arrowWidth / 2});
                }
            } else if (this.index1 - this.index2 == 1) {
                paintEvent.gc.drawLine(this.bounds.x + n / 2, this.bounds.y, this.bounds.x + n / 2, this.bounds.height);
                paintEvent.gc.fillPolygon(new int[]{this.bounds.x + this.arrowWidth, this.bounds.y, this.bounds.x, this.bounds.y + this.arrowHeight, this.bounds.x + 2 * this.arrowWidth, this.bounds.y + this.arrowHeight});
            } else if (this.index1 - this.index2 > 1) {
                paintEvent.gc.drawPolyline(new int[]{this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.y + n, this.bounds.x + n, this.bounds.height - n, this.bounds.x, this.bounds.height});
                paintEvent.gc.fillPolygon(new int[]{this.bounds.x, this.bounds.y, this.bounds.x + this.arrowWidth, this.bounds.y + this.arrowHeight + this.arrowWidth / 2, this.bounds.x + this.arrowHeight + this.arrowWidth / 2, this.bounds.y + this.arrowWidth});
            }
        }

        public void mark(boolean bl, Color color) {
            this.marked = bl;
            this.markColor = color;
        }
    }
}

