/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.menu;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.jboss.tools.jst.jsp.jspeditor.JSPMultiPageEditor;
import org.jboss.tools.vpe.editor.VpeController;
import org.jboss.tools.vpe.editor.VpeEditorPart;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.VpeElementMapping;
import org.jboss.tools.vpe.editor.menu.action.SetupTemplateAction;
import org.jboss.tools.vpe.messages.VpeUIMessages;
import org.w3c.dom.Element;

public class SetupTemplateContributionItem
extends ActionContributionItem {
    private VpePageContext pageContext;
    private StructuredTextEditor sourceEditor;
    private final JSPMultiPageEditor editor = (JSPMultiPageEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
    private final VpeController vpeController;

    public SetupTemplateContributionItem() {
        super((IAction)new SetupTemplateAction());
        this.sourceEditor = this.editor.getSourceEditor();
        this.vpeController = ((VpeEditorPart)this.editor.getVisualEditor()).getController();
        this.pageContext = this.vpeController != null ? this.vpeController.getPageContext() : null;
        this.getAction().setPageContext(this.pageContext);
    }

    public void fill(Menu menu, int index) {
        IStructuredSelection selection;
        if (this.vpeController != null && (selection = (IStructuredSelection)this.sourceEditor.getSelectionProvider().getSelection()) != null && selection.size() == 1 && selection.getFirstElement() instanceof Element) {
            Element element = (Element)selection.getFirstElement();
            VpeElementMapping elementMapping = (VpeElementMapping)this.pageContext.getDomMapping().getNodeMapping(element);
            if (elementMapping != null && elementMapping.getTemplate() != null && elementMapping.getTemplate().getType() == 4) {
                this.getAction().setText(NLS.bind((String)VpeUIMessages.SETUP_TEMPLATE_FOR_MENU, (Object)element.getNodeName()));
                this.getAction().setActionNode(element);
                this.getAction().setData(elementMapping.getTemplate().getAnyData());
                super.fill(menu, index);
            }
        }
    }

    public SetupTemplateAction getAction() {
        return (SetupTemplateAction)super.getAction();
    }
}

