/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.mozilla;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class MozillaDomBuilder {
    private Document targetDocument;
    private Element targetContentArea;

    public MozillaDomBuilder(Document targetDocument, Element targetContentArea) {
        this.targetDocument = targetDocument;
        this.targetContentArea = targetContentArea;
    }

    public void build(Document sourceDocument) {
        Element body = this.getSourceBody(sourceDocument);
        if (body != null) {
            this.build(body, this.targetContentArea);
        }
    }

    private Element getSourceBody(Document sourceDocument) {
        Element docElement = sourceDocument.getDocumentElement();
        NodeList nodes = docElement.getChildNodes();
        int len = nodes.getLength();
        int i = 0;
        while (i < len) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 1 && "BODY".equalsIgnoreCase(node.getNodeName())) {
                return (Element)node;
            }
            ++i;
        }
        return null;
    }

    private void build(Element sourseContainer, Element targetContainer) {
        NodeList sourceNodes = sourseContainer.getChildNodes();
        int len = sourceNodes.getLength();
        int i = 0;
        while (i < len) {
            Node sourceNode = sourceNodes.item(i);
            short type = sourceNode.getNodeType();
            switch (type) {
                case 1: {
                    Element newTargetElement = this.targetDocument.createElement(sourceNode.getNodeName());
                    this.buildAttributes((Element)sourceNode, newTargetElement);
                    this.build((Element)sourceNode, newTargetElement);
                    targetContainer.appendChild(newTargetElement);
                    break;
                }
                case 3: {
                    Text newTargetText = this.targetDocument.createTextNode(sourceNode.getNodeValue());
                    targetContainer.appendChild(newTargetText);
                }
            }
            ++i;
        }
    }

    private void buildAttributes(Element sourseElement, Element targetElement) {
        NamedNodeMap sourceAttributes = sourseElement.getAttributes();
        if (sourceAttributes == null) {
            return;
        }
        int len = sourceAttributes.getLength();
        int i = 0;
        while (i < len) {
            Attr sourceAttribute = (Attr)sourceAttributes.item(i);
            targetElement.setAttribute(sourceAttribute.getName(), sourceAttribute.getValue());
            ++i;
        }
    }
}

