/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.impl;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.SMap;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.impl.XModelObjectImpl;

public class RegularChildren {
    protected static XModelObject[] EMPTY = new XModelObject[0];
    protected SMap objects = null;
    protected Comparator<XModelObject> comparator = null;

    public boolean areChildrenOrdered() {
        return false;
    }

    public void clear() {
        this.objects = null;
    }

    public void setComparator(Comparator<XModelObject> c) {
        this.comparator = c;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.objects == null ? 0 : this.objects.size();
    }

    public int getChildrenCount(String entity) {
        return this.objects == null ? 0 : this.objects.getChildrenCount(entity);
    }

    public XModelObject[] getObjects() {
        return this.isEmpty() ? EMPTY : this.objects.getSortedValues(this.comparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, XModelObject> getObjectsMap() {
        HashMap<String, XModelObject> result = new HashMap<String, XModelObject>();
        if (this.objects != null) {
            Map<String, XModelObject> entries;
            Map<String, XModelObject> map = entries = this.objects.getMap();
            synchronized (map) {
                result.putAll(entries);
            }
        }
        return result;
    }

    public XModelObject getObject(String key) {
        return this.isEmpty() ? null : this.objects.get(key);
    }

    public boolean addObject(XModelObject o) {
        String pp = o.getPathPart();
        if (pp == null) {
            return false;
        }
        if (this.objects != null && this.objects.get(pp) != null) {
            if (this.objects.get(pp) == o) {
                return false;
            }
            ((XModelObjectImpl)o).setParent_0(null);
            return false;
        }
        if (this.objects == null) {
            this.objects = new SMap();
        }
        this.objects.put(pp, o);
        return true;
    }

    public boolean removeObject(XModelObject o) {
        if (this.objects == null) {
            return false;
        }
        String s = o.getPathPart();
        if (this.objects.get(s) == null) {
            return false;
        }
        ((XModelObjectImpl)o).setParent_0(null);
        this.objects.remove(s);
        if (this.objects.size() == 0) {
            this.objects = null;
        }
        return true;
    }

    public XModelObject change(XModelObject o, String opp, String npp) {
        if (opp != null && opp.equals(npp)) {
            return null;
        }
        XModelObject c = this.getObject(npp);
        if (c != null && c != o) {
            return c;
        }
        if (this.objects == null) {
            this.objects = new SMap();
        }
        if (opp != null) {
            this.objects.remove(opp);
        }
        this.objects.put(npp, o);
        if (opp != null && o.getParent() != null) {
            XModelImpl m = (XModelImpl)o.getModel();
            m.fireStructureChanged(o.getParent());
        }
        return null;
    }

    public int getIndex(XModelObject o) {
        XModelObject[] os = this.getObjects();
        int i = 0;
        while (i < os.length) {
            if (os[i] == o) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean move(int from, int to) {
        return false;
    }

    public void replaceChildren(XModelObject[] objects) {
        if (objects.length == 0) {
            if (this.objects != null) {
                this.objects = null;
            }
        } else {
            SMap m = new SMap();
            int i = 0;
            while (i < objects.length) {
                m.put(objects[i].getPathPart(), objects[i]);
                ++i;
            }
            this.objects = m;
        }
    }
}

