/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.markers;

import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.XModelObjectImpl;
import org.jboss.tools.common.model.markers.ConstraintMarkers;
import org.jboss.tools.common.model.markers.ResourceProblems;
import org.jboss.tools.common.model.util.PositionHolder;

public class ConstraintChecker {
    protected XModelObject object;
    protected ResourceProblems p;

    public ConstraintChecker(XModelObject object) {
        this.setModelObject(object);
    }

    public void setModelObject(XModelObject object) {
        this.object = object;
        this.p = new ResourceProblems(object);
    }

    public void check() {
        if (this.object == null || !this.object.isActive()) {
            return;
        }
        boolean empty = this.p.problems.isEmpty();
        this.p.problems.clear();
        this.check(this.object);
        if (!empty || !this.p.problems.isEmpty()) {
            this.addMarkers();
        }
    }

    private void check(XModelObject o) {
        XAttribute[] as = o.getModelEntity().getAttributes();
        String idAttr = null;
        int i = 0;
        while (i < as.length) {
            String error = as[i].getConstraint().getError(o.getAttributeValue(as[i].getName()));
            if (error != null) {
                this.addProblem(o, as[i].getName(), "Value " + error);
            }
            if ("true".equals(as[i].getProperty("id"))) {
                idAttr = as[i].getName();
            }
            ++i;
        }
        XModelObject[] cs = ((XModelObjectImpl)o).getLoadedChildren();
        int i2 = 0;
        while (i2 < cs.length) {
            this.check(cs[i2]);
            ++i2;
        }
        String duplicate = o.get("__duplicate");
        if (duplicate != null && duplicate.length() > 0 && idAttr != null) {
            this.addProblem(o, idAttr, "Value " + o.getAttributeValue(idAttr) + " is not unique.");
        }
    }

    protected void addProblem(XModelObject o, String attr, String msg) {
        if (o == null) {
            return;
        }
        if (msg != null) {
            PositionHolder h = PositionHolder.getPosition(o, attr);
            h.update();
            this.p.addError(o.getPath(), msg, attr, h);
        }
    }

    protected void addMarkers() {
        ConstraintMarkers markers = new ConstraintMarkers(this.p);
        markers.setModelObject(this.p.resourceObject);
        markers.update();
    }
}

