/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.editors.reveng.xpl;

import java.text.BreakIterator;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.hibernate.eclipse.mapper.editors.reveng.IFormTextEntryListener;

public class FormTextEntry {
    private static final int TOOLTIP_WIDTH_LIMIT = 300;
    private Control label;
    private Text text;
    private Button browse;
    private String value = "";
    private String description;
    private boolean dirty;
    boolean ignoreModify = false;
    private IFormTextEntryListener listener;

    public FormTextEntry(Composite parent, FormToolkit toolkit, String labelText, int style) {
        this.createControl(parent, toolkit, labelText, style, null, false, 0);
    }

    public FormTextEntry(Composite parent, FormToolkit toolkit, String labelText, String browseText, boolean linkLabel) {
        this(parent, toolkit, labelText, browseText, linkLabel, 0);
    }

    public FormTextEntry(Composite parent, FormToolkit toolkit, String labelText, String browseText, boolean linkLabel, int indent) {
        this.createControl(parent, toolkit, labelText, 4, browseText, linkLabel, indent);
    }

    public FormTextEntry(Composite parent, FormToolkit toolkit, String labelText, int style, String browseText, boolean linkLabel, int indent) {
        this.createControl(parent, toolkit, labelText, style, browseText, linkLabel, indent);
    }

    private void createControl(Composite parent, FormToolkit toolkit, String labelText, int style, String browseText, boolean linkLabel, int indent) {
        if (linkLabel) {
            Hyperlink link = toolkit.createHyperlink(parent, labelText, 0);
            this.label = link;
        } else {
            this.label = toolkit.createLabel(parent, labelText);
            this.label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            this.label.setToolTipText(this.getToolTipText(this.label));
        }
        this.text = toolkit.createText(parent, "", style);
        this.addListeners();
        if (browseText != null) {
            this.browse = toolkit.createButton(parent, browseText, 8);
            this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FormTextEntry.this.listener != null) {
                        FormTextEntry.this.listener.browseButtonSelected(FormTextEntry.this);
                    }
                }
            });
        }
        this.fillIntoGrid(parent, indent);
    }

    public void setEditable(boolean editable) {
        this.text.setEditable(editable);
        if (this.browse != null) {
            this.browse.setEnabled(editable);
        }
    }

    public void setEnabled(boolean enabled) {
    }

    private void fillIntoGrid(Composite parent, int indent) {
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            int span = ((GridLayout)layout).numColumns;
            GridData gd = new GridData(4);
            gd.horizontalIndent = indent;
            this.label.setLayoutData((Object)gd);
            int tspan = this.browse != null ? span - 2 : span - 1;
            gd = new GridData(256);
            gd.horizontalSpan = tspan;
            gd.grabExcessHorizontalSpace = tspan == 1;
            gd.widthHint = 10;
            this.text.setLayoutData((Object)gd);
            if (this.browse != null) {
                gd = new GridData(4);
                this.browse.setLayoutData((Object)gd);
            }
        } else if (layout instanceof TableWrapLayout) {
            int span = ((TableWrapLayout)layout).numColumns;
            TableWrapData td = new TableWrapData();
            td.valign = 32;
            td.indent = indent;
            this.label.setLayoutData((Object)td);
            int tspan = this.browse != null ? span - 2 : span - 1;
            td = new TableWrapData(128);
            td.colspan = tspan;
            td.grabHorizontal = tspan == 1;
            td.valign = 32;
            this.text.setLayoutData((Object)td);
            if (this.browse != null) {
                td = new TableWrapData();
                td.valign = 32;
                this.browse.setLayoutData((Object)td);
            }
        }
    }

    public void setFormEntryListener(IFormTextEntryListener listener) {
        if (this.label instanceof Hyperlink) {
            if (this.listener != null) {
                ((Hyperlink)this.label).removeHyperlinkListener((IHyperlinkListener)this.listener);
            }
            if (listener != null) {
                ((Hyperlink)this.label).addHyperlinkListener((IHyperlinkListener)listener);
            }
        }
        this.listener = listener;
    }

    private void addListeners() {
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                FormTextEntry.this.keyReleaseOccured(e);
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FormTextEntry.this.editOccured(e);
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (FormTextEntry.this.listener != null) {
                    FormTextEntry.this.listener.focusGained(FormTextEntry.this);
                }
            }

            public void focusLost(FocusEvent e) {
                if (FormTextEntry.this.dirty) {
                    FormTextEntry.this.commit();
                }
            }
        });
    }

    public void commit() {
        if (this.dirty) {
            this.value = this.text.getText();
            if (this.listener != null) {
                this.listener.textValueChanged(this);
            }
        }
        this.dirty = false;
    }

    public void cancelEdit() {
        this.dirty = false;
    }

    private void editOccured(ModifyEvent e) {
        if (this.ignoreModify) {
            return;
        }
        this.dirty = true;
        if (this.listener != null) {
            this.listener.textDirty(this);
        }
    }

    public Text getText() {
        return this.text;
    }

    public Button getButton() {
        return this.browse;
    }

    public String getValue() {
        return this.value.trim();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private void keyReleaseOccured(KeyEvent e) {
        if (e.character == '\r') {
            if (this.dirty) {
                this.commit();
            }
        } else if (e.character == '\u001b') {
            this.text.setText(this.value != null ? this.value : "");
            this.dirty = false;
        }
        this.listener.selectionChanged(this);
    }

    public void setValue(String value) {
        if (this.text != null) {
            this.text.setText(value != null ? value : "");
        }
        this.value = value != null ? value : "";
    }

    public void setValue(String value, boolean blockNotification) {
        this.ignoreModify = blockNotification;
        this.setValue(value);
        this.ignoreModify = false;
    }

    protected String getToolTipText(Control control) {
        String text = this.getDescription();
        if (text == null) {
            return null;
        }
        int dot = text.indexOf(46);
        if (dot != -1) {
            StringBuffer buf = new StringBuffer();
            boolean inTag = false;
            int i = 0;
            while (i < text.length()) {
                char c = text.charAt(i);
                if (inTag) {
                    if (c == '>') {
                        inTag = false;
                    }
                } else if (c == '<') {
                    inTag = true;
                } else {
                    char c2;
                    if (c == '.' && i < text.length() - 1 && ((c2 = text.charAt(i + 1)) == ' ' || c2 == '\t' || c2 == '\n')) break;
                    buf.append(c);
                }
                ++i;
            }
            return this.wrapText(control, buf.toString(), 300);
        }
        return text;
    }

    private String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        if (this.label != null) {
            this.label.setToolTipText(this.getToolTipText(this.label));
        }
    }

    private String wrapText(Control c, String src, int width) {
        BreakIterator wb = BreakIterator.getWordInstance();
        wb.setText(src);
        int saved = 0;
        int last = 0;
        StringBuffer buff = new StringBuffer();
        GC gc = new GC((Drawable)c);
        int loc = wb.first();
        while (loc != -1) {
            String word = src.substring(saved, loc);
            Point extent = gc.textExtent(word);
            if (extent.x > width) {
                String prevLine = src.substring(saved, last);
                buff.append(prevLine);
                buff.append('\n');
                saved = last;
            }
            last = loc;
            loc = wb.next();
        }
        gc.dispose();
        String lastLine = src.substring(saved, last);
        buff.append(lastLine);
        return buff.toString();
    }
}

