/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.reporter;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.reporter.MarkerParameter;
import de.tobject.findbugs.reporter.MarkerUtil;
import edu.umd.cs.findbugs.AppVersion;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.config.ProjectFilterSettings;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerReporter
implements IWorkspaceRunnable {
    private final BugCollection collection;
    private static final boolean EXPERIMENTAL_BUGS = false;
    private final List<MarkerParameter> mpList;
    private final IProject project;

    public MarkerReporter(List<MarkerParameter> mpList, BugCollection theCollection, IProject project) {
        this.mpList = mpList;
        this.collection = theCollection;
        this.project = project;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        UserPreferences userPrefs = FindbugsPlugin.getUserPreferences(this.project);
        ProjectFilterSettings filterSettings = userPrefs.getFilterSettings();
        for (MarkerParameter mp : this.mpList) {
            String markerType;
            if (!MarkerUtil.shouldDisplayWarning(mp.bug, filterSettings) || (markerType = this.getMarkerType(mp.bug)) == null) continue;
            this.addMarker(markerType, mp);
        }
    }

    private void addMarker(String markerType, MarkerParameter mp) throws CoreException {
        IMarker oldMarker;
        IResource markerTarget = mp.resource.getMarkerTarget();
        IMarker[] existingMarkers = markerTarget.findMarkers(markerType, true, 0);
        Map<String, Object> attributes = this.createMarkerAttributes(mp);
        if (existingMarkers.length > 0 && (oldMarker = this.findSameBug(attributes, existingMarkers)) != null) {
            oldMarker.delete();
        }
        IMarker newMarker = markerTarget.createMarker(markerType);
        this.setAttributes(newMarker, attributes);
    }

    @CheckForNull
    private IMarker findSameBug(Map<String, Object> attributes, IMarker[] existingMarkers) throws CoreException {
        Object bugId = attributes.get("FINDBUGS_UNIQUE_ID");
        if (bugId == null) {
            return null;
        }
        for (IMarker marker : existingMarkers) {
            Object idAttribute = marker.getAttribute("FINDBUGS_UNIQUE_ID");
            if (!bugId.equals(idAttribute)) continue;
            return marker;
        }
        return null;
    }

    private String getMarkerType(BugInstance bug) {
        String markerType;
        switch (bug.getPriority()) {
            case 1: {
                markerType = "edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerHigh";
                break;
            }
            case 2: {
                markerType = "edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerNormal";
                break;
            }
            case 3: {
                markerType = "edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerLow";
                break;
            }
            case 4: {
                return null;
            }
            case 5: {
                FindbugsPlugin.getDefault().logError("Bug with ignore priority ");
                return null;
            }
            default: {
                FindbugsPlugin.getDefault().logError("Bug with unknown priority " + bug.getPriority());
                return null;
            }
        }
        return markerType;
    }

    private Map<String, Object> createMarkerAttributes(MarkerParameter mp) {
        IJavaElement javaElt;
        HashMap<String, Object> attributes = new HashMap<String, Object>(23);
        attributes.put("lineNumber", mp.startLine);
        attributes.put("PRIMARY_LINE", mp.primaryLine);
        attributes.put("BUGTYPE", mp.bug.getType());
        attributes.put("PATTERNTYPE", mp.bug.getAbbrev());
        long seqNum = mp.bug.getFirstVersion();
        if (seqNum == 0L) {
            attributes.put("FIRST_VERSION", "-1");
        } else {
            AppVersion theVersion = this.collection.getAppVersionFromSequenceNumber(seqNum);
            if (theVersion == null) {
                attributes.put("FIRST_VERSION", "Cannot find AppVersion: seqnum=" + seqNum + "; collection seqnum=" + this.collection.getSequenceNumber());
            } else {
                attributes.put("FIRST_VERSION", Long.toString(theVersion.getTimestamp()));
            }
        }
        try {
            attributes.put("message", mp.bug.getAbridgedMessage());
        }
        catch (RuntimeException e) {
            FindbugsPlugin.getDefault().logException(e, "Error generating msg for " + mp.bug.getType());
            attributes.put("message", "??? " + mp.bug.getType());
        }
        attributes.put("severity", 1);
        attributes.put("PRIORITY_TYPE", mp.bug.getPriorityTypeString());
        switch (mp.bug.getPriority()) {
            case 1: {
                attributes.put("priority", 2);
                break;
            }
            case 2: {
                attributes.put("priority", 1);
                break;
            }
            default: {
                attributes.put("priority", 0);
            }
        }
        String uniqueId = mp.bug.getInstanceHash();
        if (uniqueId != null) {
            attributes.put("FINDBUGS_UNIQUE_ID", uniqueId);
        }
        if ((javaElt = mp.resource.getCorespondingJavaElement()) != null) {
            attributes.put("UNIQUE_JAVA_ID", javaElt.getHandleIdentifier());
        }
        return attributes;
    }

    private void setAttributes(IMarker marker, Map<String, Object> attributes) throws CoreException {
        marker.setAttributes(attributes);
    }
}

