/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import java.util.ArrayList;
import java.util.List;

public class SwitchHandler {
    private final List<SwitchDetails> switchOffsetStack = new ArrayList<SwitchDetails>();

    public void enterSwitch(DismantleBytecode dbc) {
        SwitchDetails details = new SwitchDetails(dbc.getPC(), dbc.getSwitchOffsets(), dbc.getDefaultSwitchOffset());
        int size = this.switchOffsetStack.size();
        while (--size >= 0) {
            SwitchDetails existingDetail = this.switchOffsetStack.get(size);
            if (details.switchPC <= existingDetail.switchPC + existingDetail.swOffsets[existingDetail.swOffsets.length - 1]) continue;
            this.switchOffsetStack.remove(size);
        }
        this.switchOffsetStack.add(details);
    }

    public boolean isOnSwitchOffset(DismantleBytecode dbc) {
        int pc = dbc.getPC();
        if (pc == this.getDefaultOffset()) {
            return false;
        }
        return pc == this.getNextSwitchOffset(dbc);
    }

    public int getNextSwitchOffset(DismantleBytecode dbc) {
        for (int size = this.switchOffsetStack.size(); size > 0; --size) {
            SwitchDetails details = this.switchOffsetStack.get(size - 1);
            int nextSwitchOffset = details.getNextSwitchOffset(dbc.getPC());
            if (nextSwitchOffset >= 0) {
                return nextSwitchOffset;
            }
            if (dbc.getPC() <= details.getDefaultOffset()) {
                return -1;
            }
            this.switchOffsetStack.remove(size - 1);
        }
        return -1;
    }

    public int getDefaultOffset() {
        int size = this.switchOffsetStack.size();
        if (size == 0) {
            return -1;
        }
        SwitchDetails details = this.switchOffsetStack.get(size - 1);
        return details.getDefaultOffset();
    }

    public static class SwitchDetails {
        final int switchPC;
        final int[] swOffsets;
        final int defaultOffset;
        int nextOffset;

        public SwitchDetails(int pc, int[] offsets, int defOffset) {
            this.switchPC = pc;
            int uniqueOffsets = 0;
            int lastValue = -1;
            for (int offset : offsets) {
                if (offset == lastValue) continue;
                ++uniqueOffsets;
                lastValue = offset;
            }
            this.swOffsets = new int[uniqueOffsets];
            int insertPos = 0;
            lastValue = -1;
            for (int offset1 : offsets) {
                if (offset1 == lastValue) continue;
                this.swOffsets[insertPos++] = offset1;
                lastValue = offset1;
            }
            this.defaultOffset = defOffset;
            this.nextOffset = 0;
        }

        public int getNextSwitchOffset(int currentPC) {
            while (this.nextOffset < this.swOffsets.length && currentPC > this.switchPC + this.swOffsets[this.nextOffset]) {
                ++this.nextOffset;
            }
            if (this.nextOffset >= this.swOffsets.length) {
                return -1;
            }
            return this.switchPC + this.swOffsets[this.nextOffset];
        }

        public int getDefaultOffset() {
            return this.switchPC + this.defaultOffset;
        }
    }
}

