/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.MissingClassException;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.util.DualKeyHashMap;
import edu.umd.cs.findbugs.util.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeQualifierValue {
    public static final boolean DEBUG = SystemProperties.getBoolean("tqv.debug");
    private static final ClassDescriptor EXCLUSIVE_ANNOTATION = DescriptorFactory.instance().getClassDescriptor("javax/annotation/meta/Exclusive");
    private static final ClassDescriptor EXHAUSTIVE_ANNOTATION = DescriptorFactory.instance().getClassDescriptor("javax/annotation/meta/Exhaustive");
    public final ClassDescriptor typeQualifier;
    @CheckForNull
    public final Object value;
    private boolean isStrict;
    private boolean isExclusive;
    private boolean isExhaustive;
    private static ThreadLocal<Data> instance = new ThreadLocal<Data>(){

        @Override
        protected Data initialValue() {
            return new Data();
        }
    };

    private TypeQualifierValue(ClassDescriptor typeQualifier, @CheckForNull Object value) {
        this.typeQualifier = typeQualifier;
        this.value = value;
        this.isStrict = false;
        this.isExclusive = false;
        this.isExhaustive = false;
    }

    public static void clearInstance() {
        instance.remove();
    }

    @NonNull
    public static TypeQualifierValue getValue(ClassDescriptor desc, Object value) {
        DualKeyHashMap<ClassDescriptor, Object, TypeQualifierValue> map = TypeQualifierValue.instance.get().typeQualifierMap;
        TypeQualifierValue result = map.get(desc, value);
        if (result != null) {
            return result;
        }
        result = new TypeQualifierValue(desc, value);
        TypeQualifierValue.determineIfQualifierIsStrict(desc, result);
        TypeQualifierValue.determineIfQualifierIsExclusiveOrExhaustive(desc, result);
        map.put(desc, value, result);
        TypeQualifierValue.instance.get().allKnownTypeQualifiers.add(result);
        return result;
    }

    public static Collection<TypeQualifierValue> getAllKnownTypeQualifiers() {
        return Collections.unmodifiableSet(TypeQualifierValue.instance.get().allKnownTypeQualifiers);
    }

    public static Collection<TypeQualifierValue> getComplementaryExclusiveTypeQualifierValue(TypeQualifierValue tqv) {
        assert (tqv.isExclusiveQualifier());
        LinkedList<TypeQualifierValue> result = new LinkedList<TypeQualifierValue>();
        for (TypeQualifierValue t : TypeQualifierValue.instance.get().allKnownTypeQualifiers) {
            if (!t.typeQualifier.equals(tqv.typeQualifier) || Util.nullSafeEquals(t.value, tqv.value)) continue;
            result.add(t);
        }
        return result;
    }

    public static boolean hasMultipleVariants(TypeQualifierValue tqv) {
        int count = 0;
        for (TypeQualifierValue t : TypeQualifierValue.instance.get().allKnownTypeQualifiers) {
            if (!t.typeQualifier.equals(tqv.typeQualifier)) continue;
            ++count;
        }
        return count > 1;
    }

    private static void determineIfQualifierIsStrict(ClassDescriptor desc, TypeQualifierValue result) {
        if (DEBUG) {
            System.out.print("Checking to see if " + desc + " requires strict checking...");
        }
        try {
            XClass xclass = Global.getAnalysisCache().getClassAnalysis(XClass.class, desc);
            XMethod whenMethod = xclass.findMethod("when", "()Ljavax/annotation/meta/When;", false);
            if (whenMethod == null) {
                result.setIsStrict();
            }
        }
        catch (MissingClassException e) {
            AnalysisContext.currentAnalysisContext().getLookupFailureCallback().reportMissingClass(e.getClassNotFoundException());
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Error looking up annotation class " + desc.toDottedClassName(), e);
        }
        if (DEBUG) {
            System.out.println(result.isStrictQualifier() ? "yes" : "no");
        }
    }

    private static void determineIfQualifierIsExclusiveOrExhaustive(ClassDescriptor desc, TypeQualifierValue result) {
        if (DEBUG) {
            System.out.print("Checking to see if " + desc + " is exclusive or exhaustive...");
        }
        boolean isExclusive = false;
        boolean isExhaustive = false;
        try {
            XClass xclass = Global.getAnalysisCache().getClassAnalysis(XClass.class, desc);
            for (XMethod xMethod : xclass.getXMethods()) {
                if (!xMethod.getName().equals("value") || !xMethod.getSignature().startsWith("()")) continue;
                boolean bl = isExhaustive = xMethod.getAnnotation(EXHAUSTIVE_ANNOTATION) != null;
                isExclusive = isExhaustive ? true : xMethod.getAnnotation(EXCLUSIVE_ANNOTATION) != null;
                break;
            }
        }
        catch (MissingClassException e) {
            AnalysisContext.currentAnalysisContext().getLookupFailureCallback().reportMissingClass(e.getClassNotFoundException());
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Error looking up annotation class " + desc.toDottedClassName(), e);
        }
        if (isExclusive) {
            result.setIsExclusive();
        }
        if (isExhaustive) {
            result.setIsExhaustive();
        }
        if (DEBUG) {
            if (isExhaustive) {
                System.out.println("exhaustive,exclusive");
            } else if (isExclusive) {
                System.out.println("exclusive");
            } else {
                System.out.println("neither");
            }
        }
    }

    public ClassDescriptor getTypeQualifierClassDescriptor() {
        return this.typeQualifier;
    }

    private void setIsStrict() {
        this.isStrict = true;
    }

    public boolean isStrictQualifier() {
        return this.isStrict;
    }

    private void setIsExclusive() {
        this.isExclusive = true;
    }

    public boolean isExclusiveQualifier() {
        return this.isExclusive;
    }

    private void setIsExhaustive() {
        this.isExhaustive = true;
    }

    public boolean isExhaustiveQualifier() {
        return this.isExhaustive;
    }

    public int hashCode() {
        int result = this.typeQualifier.hashCode();
        if (this.value != null) {
            result += 37 * this.value.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TypeQualifierValue)) {
            return false;
        }
        TypeQualifierValue other = (TypeQualifierValue)o;
        return this.typeQualifier.equals(other.typeQualifier) && Util.nullSafeEquals(this.value, other.value);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.typeQualifier.toString());
        if (this.value != null) {
            buf.append(':');
            buf.append(this.value.toString());
        }
        return buf.toString();
    }

    static class Data {
        DualKeyHashMap<ClassDescriptor, Object, TypeQualifierValue> typeQualifierMap = new DualKeyHashMap();
        Set<TypeQualifierValue> allKnownTypeQualifiers = new HashSet<TypeQualifierValue>();

        Data() {
        }
    }
}

