/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.cloud;

import edu.umd.cs.findbugs.AppVersion;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugDesignation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.cloud.AbstractCloud;
import edu.umd.cs.findbugs.cloud.Cloud;

class BugCollectionStorageCloud
extends AbstractCloud {
    BugCollectionStorageCloud(BugCollection bc) {
        super(bc);
    }

    public Cloud.Mode getMode() {
        return Cloud.Mode.COMMUNAL;
    }

    public String getUser() {
        return null;
    }

    public Cloud.UserDesignation getUserDesignation(BugInstance b) {
        BugDesignation bd = b.getUserDesignation();
        if (bd == null) {
            return Cloud.UserDesignation.UNCLASSIFIED;
        }
        return Cloud.UserDesignation.valueOf(bd.getDesignationKey());
    }

    public String getUserEvaluation(BugInstance b) {
        BugDesignation bd = b.getUserDesignation();
        if (bd == null) {
            return "";
        }
        return bd.getAnnotationText();
    }

    public long getUserTimestamp(BugInstance b) {
        BugDesignation bd = b.getUserDesignation();
        if (bd == null) {
            return Long.MAX_VALUE;
        }
        return bd.getTimestamp();
    }

    public void setMode(Cloud.Mode m) {
    }

    public void setUserDesignation(BugInstance b, Cloud.UserDesignation u, long timestamp) {
        BugDesignation bd = b.getNonnullUserDesignation();
        bd.setDesignationKey(u.name());
        bd.setTimestamp(timestamp);
    }

    public void setUserEvaluation(BugInstance b, String e, long timestamp) {
        BugDesignation bd = b.getNonnullUserDesignation();
        bd.setAnnotationText(e);
        bd.setTimestamp(timestamp);
        bd.setUser(this.getUser());
    }

    public void setUserTimestamp(BugInstance b, long timestamp) {
        BugDesignation bd = b.getNonnullUserDesignation();
        bd.setTimestamp(timestamp);
        bd.setUser(this.getUser());
    }

    public long getFirstSeen(BugInstance b) {
        long firstVersion = b.getFirstVersion();
        AppVersion v = this.bugCollection.getAppVersionFromSequenceNumber(firstVersion);
        if (v == null) {
            return this.bugCollection.getTimestamp();
        }
        return v.getTimestamp();
    }

    public void bugsPopulated() {
    }

    public boolean availableForInitialization() {
        return true;
    }

    public boolean initialize() {
        return true;
    }

    public void storeUserAnnotation(BugInstance bugInstance) {
    }

    public boolean bugLinkEnabled(String label) {
        throw new UnsupportedOperationException();
    }

    public void bugFiled(BugInstance b, Object bugLink) {
        throw new UnsupportedOperationException();
    }
}

