/*
 * JBoss, the OpenSource EJB server
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package javax.resource.cci;

import javax.resource.ResourceException;

/**
 * ResourceWarning provides information on warnings generated by the underlying
 * resource. They are chained to an Interaction object for later retrieval.
 */
public class ResourceWarning extends ResourceException
{
   /**
    * Create a warning
    */
   public ResourceWarning()
   {
      super();
   }

   /**
	 * Create a warning with a reason.
	 */
   public ResourceWarning(String reason)
   {
      super(reason);
   }

   /**
	 * Create a warning with a reason and an errorCode.
	 */
   public ResourceWarning(String reason, String errorCode)
   {
      super(reason, errorCode);
   }

   /**
    * Create a warning with a reason and an error.
    * 
    * @param reason the reason
    * @param throwable the error
    */
   public ResourceWarning(String reason, Throwable throwable)
   {
      super(reason, throwable);
   }

   /**
    * Create a warning with an error.
    * 
    * @param throwable the error
    */
   public ResourceWarning(Throwable throwable)
   {
      super(throwable);
   }
   
   /**
	 * Set a linked warning.
    * 
    * @deprecated use initCause()
	 */
   public void setLinkedWarning(ResourceWarning linkedWarning)
   {
      setLinkedException(linkedWarning);
   }

   /**
	 * Get any linked warning.
    * 
    * @deprecated use getCause()
	 */
   public ResourceWarning getLinkedWarning()
   {
      return (ResourceWarning) getLinkedException();
   }
}