/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;
import org.hibernate.console.QueryPage;

public class QueryPageModel
extends AbstractListModel {
    List<QueryPage> pages = new ArrayList<QueryPage>();
    PropertyChangeListener pcl = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            QueryPageModel.this.update(QueryPageModel.this.pages.indexOf(evt.getSource()));
        }
    };

    @Override
    public int getSize() {
        return this.pages.size();
    }

    @Override
    public QueryPage getElementAt(int index) {
        return this.pages.get(index);
    }

    public void add(QueryPage qp) {
        int i = this.pages.size() - 1;
        while (i >= 0) {
            QueryPage element = this.pages.get(i);
            if (!element.isSticky()) {
                this.pages.remove(i);
            }
            --i;
        }
        this.pages.add(qp);
        this.fireIntervalAdded(this, 0, this.pages.size());
    }

    public void remove(int i) {
        QueryPage qp = this.pages.remove(i);
        if (qp != null) {
            qp.removePropertyChangeListener(this.pcl);
        }
        this.fireIntervalRemoved(this.pages, i, i);
    }

    public QueryPage get(int i) {
        return this.getElementAt(i);
    }

    protected void update(int index) {
        this.fireContentsChanged(this.pages, index, index);
    }

    public Iterator<QueryPage> getPages() {
        return this.pages.iterator();
    }

    public List<QueryPage> getPagesAsList() {
        return new ArrayList<QueryPage>(this.pages);
    }

    public boolean remove(QueryPage page) {
        boolean b = this.pages.remove(page);
        if (b) {
            this.fireContentsChanged(this.pages, 0, this.getSize());
            page.release();
        }
        return b;
    }
}

