/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.logging;

import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.HierarchyEventListener;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RepositorySelector;
import org.apache.log4j.spi.RootLogger;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.hibernate.console.execution.DefaultExecutionContext;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.eclipse.logging.LoggingHelper;
import org.hibernate.eclipse.logging.PluginFileAppender;
import org.hibernate.eclipse.logging.PluginLogAppender;
import org.hibernate.eclipse.logging.PluginLogListener;

public class PluginLogManager {
    private ILog log;
    private IPath stateLocation;
    private Hierarchy hierarchy;
    private HashMap<String, ILogListener> hookedPlugins = new HashMap();
    private LoggingHelper helper;

    public PluginLogManager(Plugin plugin, LoggingHelper helper, final URL log4jUrl) {
        this.log = plugin.getLog();
        this.stateLocation = plugin.getStateLocation();
        this.hierarchy = new Hierarchy((Logger)new RootLogger(Level.DEBUG));
        this.hierarchy.addHierarchyEventListener((HierarchyEventListener)new PluginEventListener());
        LogManager.setRepositorySelector((RepositorySelector)new RepositorySelector(){

            public LoggerRepository getLoggerRepository() {
                return PluginLogManager.this.hierarchy;
            }
        }, (Object)"hibernate-tools");
        DefaultExecutionContext ec = new DefaultExecutionContext("logConfiguration", this.getClass().getClassLoader());
        ec.execute(new ExecutionContext.Command(){

            @Override
            public Object execute() {
                OptionConverter.selectAndConfigure((URL)log4jUrl, null, (LoggerRepository)PluginLogManager.this.hierarchy);
                return null;
            }
        });
        this.helper = helper;
        helper.addLogManager(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hookPlugin(String id, ILog pluginLog) {
        HashMap<String, ILogListener> hashMap = this.hookedPlugins;
        synchronized (hashMap) {
            block4: {
                if (pluginLog != null && id != null && !this.hookedPlugins.containsKey(id)) break block4;
                return false;
            }
            PluginLogListener listener = new PluginLogListener(pluginLog, this.getLogger(id));
            this.hookedPlugins.put(id, listener);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unHookPlugin(String id) {
        HashMap<String, ILogListener> hashMap = this.hookedPlugins;
        synchronized (hashMap) {
            block4: {
                if (id != null && this.hookedPlugins.containsKey(id)) break block4;
                return false;
            }
            PluginLogListener listener = (PluginLogListener)this.hookedPlugins.get(id);
            listener.dispose();
            this.hookedPlugins.remove(id);
        }
        return true;
    }

    public boolean isDisabled(int level) {
        return this.hierarchy.isDisabled(level);
    }

    public void setThreshold(Level level) {
        this.hierarchy.setThreshold(level);
    }

    public void setThreshold(String level) {
        this.hierarchy.setThreshold(level);
    }

    public Level getThreshold() {
        return this.hierarchy.getThreshold();
    }

    public Logger getLogger(String name) {
        return this.hierarchy.getLogger(name);
    }

    public Logger getLogger(String name, LoggerFactory factory) {
        return this.hierarchy.getLogger(name, factory);
    }

    public Logger getRootLogger() {
        return this.hierarchy.getRootLogger();
    }

    public Logger exists(String name) {
        return this.hierarchy.exists(name);
    }

    public void shutdown() {
        this.internalShutdown();
        this.helper.removeLogManager(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalShutdown() {
        HashMap<String, ILogListener> hashMap = this.hookedPlugins;
        synchronized (hashMap) {
            for (String id : this.hookedPlugins.keySet()) {
                PluginLogListener listener = (PluginLogListener)this.hookedPlugins.get(id);
                listener.dispose();
            }
            this.hookedPlugins.clear();
        }
        this.hierarchy.shutdown();
    }

    public Enumeration<?> getCurrentLoggers() {
        return this.hierarchy.getCurrentLoggers();
    }

    public void resetConfiguration() {
        this.hierarchy.resetConfiguration();
    }

    private class PluginEventListener
    implements HierarchyEventListener {
        private PluginEventListener() {
        }

        public void addAppenderEvent(Category cat, Appender appender) {
            if (appender instanceof PluginLogAppender) {
                ((PluginLogAppender)appender).setLog(PluginLogManager.this.log);
            }
            if (appender instanceof PluginFileAppender) {
                ((PluginFileAppender)appender).setStateLocation(PluginLogManager.this.stateLocation);
            }
        }

        public void removeAppenderEvent(Category cat, Appender appender) {
        }
    }
}

