/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.spec.se.manifest;

import java.util.jar.Attributes;
import org.jboss.shrinkwrap.descriptor.api.spec.se.manifest.ManifestAppletDef;
import org.jboss.shrinkwrap.descriptor.impl.spec.se.manifest.ManifestDescriptorImpl;
import org.jboss.shrinkwrap.descriptor.impl.spec.se.manifest.ManifestModel;

public class ManifestAppletDefImpl
extends ManifestDescriptorImpl
implements ManifestAppletDef {
    private final String appletName;

    public ManifestAppletDefImpl(String descriptorName, ManifestModel manifest, String appletName) {
        super(descriptorName, manifest);
        this.appletName = appletName;
        Attributes mainAttributes = manifest.getMainAttributes();
        String extensionListValue = mainAttributes.containsKey(Attributes.Name.EXTENSION_LIST) ? String.valueOf(mainAttributes.get(Attributes.Name.EXTENSION_LIST)) + " " + appletName : appletName;
        manifest.getMainAttributes().put(Attributes.Name.EXTENSION_LIST, extensionListValue);
    }

    public ManifestAppletDef appletExtensionName(String name) {
        this.includeAttributeWithPrefix(Attributes.Name.EXTENSION_NAME, name);
        return this;
    }

    public ManifestAppletDef appletSpecificationVersion(String version) {
        this.includeAttributeWithPrefix(Attributes.Name.SPECIFICATION_VERSION, version);
        return this;
    }

    public ManifestAppletDef appletImplementationVersion(String version) {
        this.includeAttributeWithPrefix(Attributes.Name.IMPLEMENTATION_VERSION, version);
        return this;
    }

    public ManifestAppletDef appletImplementationVendorId(String vendorId) {
        this.includeAttributeWithPrefix(Attributes.Name.IMPLEMENTATION_VENDOR_ID, vendorId);
        return this;
    }

    public ManifestAppletDef appletImplementationUrl(String url) {
        this.includeAttributeWithPrefix(Attributes.Name.IMPLEMENTATION_URL, url);
        return this;
    }

    private void includeAttributeWithPrefix(Attributes.Name name, String value) {
        super.attribute(this.addPrefix(name), value);
    }

    private String addPrefix(Attributes.Name extensionName) {
        return this.appletName + "-" + extensionName.toString();
    }
}

