/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.spec.se.manifest;

import java.util.Map;
import java.util.jar.Attributes;
import org.jboss.shrinkwrap.descriptor.api.spec.se.manifest.ManifestAppletDef;
import org.jboss.shrinkwrap.descriptor.api.spec.se.manifest.ManifestDescriptor;
import org.jboss.shrinkwrap.descriptor.api.spec.se.manifest.ManifestEntryDef;
import org.jboss.shrinkwrap.descriptor.impl.spec.se.manifest.ManifestCommonDefImpl;
import org.jboss.shrinkwrap.descriptor.impl.spec.se.manifest.ManifestModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestEntryDefImpl
extends ManifestCommonDefImpl<ManifestEntryDef>
implements ManifestEntryDef {
    private final ManifestModel manifest;
    private final ManifestDescriptor manifestDescriptor;
    private final String entryName;

    public ManifestEntryDefImpl(ManifestDescriptor manifestDescriptor, ManifestModel manifest, String name) {
        this.manifestDescriptor = manifestDescriptor;
        this.manifest = manifest;
        this.entryName = name;
    }

    @Override
    ManifestEntryDef getDescriptor() {
        return this;
    }

    @Override
    public ManifestDescriptor main() {
        return this.manifestDescriptor;
    }

    @Override
    public ManifestAppletDef applet(String name) {
        return this.manifestDescriptor.applet(name);
    }

    @Override
    public ManifestEntryDef entry(String name) {
        return this.manifestDescriptor.entry(name);
    }

    @Override
    public ManifestEntryDef contentType(String contentType) {
        this.includeAttribute(Attributes.Name.CONTENT_TYPE, contentType);
        return this;
    }

    @Override
    public ManifestEntryDef javaBean() {
        this.includeAttribute(JAVA_BEAN, TRUE);
        return this;
    }

    @Override
    public ManifestEntryDef notJavaBean() {
        this.includeAttribute(JAVA_BEAN, FALSE);
        return this;
    }

    @Override
    public ManifestEntryDef xDigestY(String digestAlgorithm) {
        this.includeAttribute(X_DIGEST_Y, digestAlgorithm);
        return this;
    }

    @Override
    public ManifestEntryDef magic(String magic) {
        this.includeAttribute(MAGIC, magic);
        return this;
    }

    @Override
    void includeAttribute(Attributes.Name attribute, String value) {
        Map<String, Attributes> entries = this.manifest.getEntries();
        Attributes attributes = entries.containsKey(this.entryName) ? this.manifest.getAttributes(this.entryName) : new Attributes();
        attributes.put(attribute, value);
        entries.put(this.entryName, attributes);
    }

    @Override
    String findAttribute(Attributes.Name name) {
        Map<String, Attributes> entries = this.manifest.getEntries();
        if (entries.containsKey(this.entryName)) {
            return this.manifest.getAttributes(this.entryName).getValue(name);
        }
        return null;
    }

    @Override
    ManifestModel getManifestModel() {
        return this.manifest;
    }

    public String getDescriptorName() {
        return this.manifestDescriptor.getDescriptorName();
    }
}

