/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.project.dependencies;

import java.util.ArrayList;
import java.util.List;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyBuilder;
import org.jboss.forge.project.dependencies.ScopeType;
import org.jboss.forge.project.packaging.PackagingType;

public class DependencyImpl
implements Dependency {
    private String groupId;
    private String artifactId;
    private String version;
    private String scopeType;
    private String packagingType;
    private String classifier;
    private List<Dependency> excludedDependencies = new ArrayList<Dependency>();

    DependencyImpl() {
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getScopeType() {
        return this.scopeType;
    }

    @Override
    public PackagingType getPackagingTypeEnum() {
        return PackagingType.from(this.getPackagingType());
    }

    @Override
    public ScopeType getScopeTypeEnum() {
        return ScopeType.from(this.getScopeType());
    }

    public void setScopeType(ScopeType scope) {
        this.scopeType = scope == null ? null : scope.getScope();
    }

    public void setScopeType(String type) {
        this.scopeType = type;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    @Override
    public List<Dependency> getExcludedDependencies() {
        return this.excludedDependencies;
    }

    public void setExcludedDependencies(List<Dependency> excludedDependencies) {
        this.excludedDependencies = excludedDependencies;
    }

    @Override
    public String getPackagingType() {
        return this.packagingType;
    }

    public void setPackagingType(PackagingType packagingType) {
        this.packagingType = packagingType == null ? null : packagingType.getType();
    }

    public void setPackagingType(String type) {
        this.packagingType = type;
    }

    @Override
    public String toCoordinates() {
        return DependencyBuilder.toId(this);
    }

    public String toString() {
        return DependencyBuilder.toString(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.excludedDependencies == null ? 0 : ((Object)this.excludedDependencies).hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.packagingType == null ? 0 : this.packagingType.hashCode());
        result = 31 * result + (this.scopeType == null ? 0 : this.scopeType.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Dependency)) {
            return false;
        }
        Dependency that = (Dependency)o;
        boolean exclusionsEqual = false;
        if (this.excludedDependencies != null) {
            if (that.getExcludedDependencies() != null) {
                ArrayList<Dependency> temp = new ArrayList<Dependency>();
                temp.addAll(this.excludedDependencies);
                if (temp.containsAll(that.getExcludedDependencies())) {
                    temp.removeAll(that.getExcludedDependencies());
                    if (temp.isEmpty()) {
                        exclusionsEqual = true;
                    }
                }
            }
        } else {
            boolean bl = exclusionsEqual = that.getExcludedDependencies() == null;
        }
        return this.artifactId != null ? this.artifactId.equals(that.getArtifactId()) : (that.getArtifactId() != null && exclusionsEqual && this.groupId != null ? this.groupId.equals(that.getGroupId()) : (that.getGroupId() != null && this.packagingType != null ? !this.packagingType.equals(that.getPackagingType()) : (that.getPackagingType() != null && this.scopeType != null ? this.scopeType.equals(that.getScopeType()) : (that.getScopeType() != null && this.version != null ? this.version.equals(that.getVersion()) : (that.getVersion() != null && this.classifier != null ? this.classifier.equals(that.getClassifier()) : that.getClassifier() != null)))));
    }
}

