/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.jboss.solder.bean.ImmutableInjectionPoint;
import org.jboss.solder.reflection.Reflections;

public class Beans {
    private Beans() {
    }

    public static Set<Annotation> getQualifiers(BeanManager beanManager, Iterable<Annotation> ... annotations) {
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        for (Iterable<Annotation> annotationSet : annotations) {
            for (Annotation annotation : annotationSet) {
                if (!beanManager.isQualifier(annotation.annotationType())) continue;
                qualifiers.add(annotation);
            }
        }
        return qualifiers;
    }

    public static Set<Annotation> getQualifiers(BeanManager beanManager, Iterable<Annotation> annotations) {
        return Beans.getQualifiers(beanManager, new Iterable[]{annotations});
    }

    public static Set<Annotation> getQualifiers(BeanManager beanManager, Annotation[] ... annotations) {
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        Annotation[][] arr$ = annotations;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] annotationArray;
            for (Annotation annotation : annotationArray = arr$[i$]) {
                if (!beanManager.isQualifier(annotation.annotationType())) continue;
                qualifiers.add(annotation);
            }
        }
        return qualifiers;
    }

    public static void checkReturnValue(Object instance, Bean<?> bean, InjectionPoint injectionPoint, BeanManager beanManager) {
        if (instance == null && !Dependent.class.equals((Object)bean.getScope())) {
            throw new IllegalStateException("Cannot return null from a non-dependent producer method: " + bean);
        }
        if (instance != null) {
            boolean passivating = beanManager.isPassivatingScope(bean.getScope());
            boolean instanceSerializable = Reflections.isSerializable(instance.getClass());
            if (passivating && !instanceSerializable) {
                throw new IllegalStateException("Producers cannot declare passivating scope and return a non-serializable class: " + bean);
            }
            if (injectionPoint != null && injectionPoint.getBean() != null && !instanceSerializable && beanManager.isPassivatingScope(injectionPoint.getBean().getScope())) {
                if (injectionPoint.getMember() instanceof Field) {
                    if (!injectionPoint.isTransient() && instance != null && !instanceSerializable) {
                        throw new IllegalStateException("Producers cannot produce non-serializable instances for injection into non-transient fields of passivating beans. Producer " + bean + "at injection point " + injectionPoint);
                    }
                } else if (injectionPoint.getMember() instanceof Method) {
                    Method method = (Method)injectionPoint.getMember();
                    if (method.isAnnotationPresent(Inject.class)) {
                        throw new IllegalStateException("Producers cannot produce non-serializable instances for injection into parameters of initializers of beans declaring passivating scope. Producer " + bean + "at injection point " + injectionPoint);
                    }
                    if (method.isAnnotationPresent(Produces.class)) {
                        throw new IllegalStateException("Producers cannot produce non-serializable instances for injection into parameters of producer methods declaring passivating scope. Producer " + bean + "at injection point " + injectionPoint);
                    }
                } else if (injectionPoint.getMember() instanceof Constructor) {
                    throw new IllegalStateException("Producers cannot produce non-serializable instances for injection into parameters of constructors of beans declaring passivating scope. Producer " + bean + "at injection point " + injectionPoint);
                }
            }
        }
    }

    public static <X> List<InjectionPoint> createInjectionPoints(AnnotatedMethod<X> method, Bean<?> declaringBean, BeanManager beanManager) {
        ArrayList<InjectionPoint> injectionPoints = new ArrayList<InjectionPoint>();
        for (AnnotatedParameter parameter : method.getParameters()) {
            ImmutableInjectionPoint injectionPoint = new ImmutableInjectionPoint(parameter, beanManager, declaringBean, false, false);
            injectionPoints.add(injectionPoint);
        }
        return injectionPoints;
    }
}

