/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.Dictionary;
import org.eclipse.osgi.internal.resolver.BaseDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.NativeCodeDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class NativeCodeDescriptionImpl
extends BaseDescriptionImpl
implements NativeCodeDescription {
    private static final VersionRange[] EMPTY_VERSIONRANGES = new VersionRange[0];
    private Filter filter;
    private String[] languages;
    private String[] nativePaths;
    private String[] osNames;
    private VersionRange[] osVersions;
    private String[] processors;
    private BundleDescription supplier;
    private boolean invalidNativePaths = false;

    public Filter getFilter() {
        return this.filter;
    }

    public String[] getLanguages() {
        if (this.languages == null) {
            return BundleDescriptionImpl.EMPTY_STRING;
        }
        return this.languages;
    }

    public String[] getNativePaths() {
        if (this.nativePaths == null) {
            return BundleDescriptionImpl.EMPTY_STRING;
        }
        return this.nativePaths;
    }

    public String[] getOSNames() {
        if (this.osNames == null) {
            return BundleDescriptionImpl.EMPTY_STRING;
        }
        return this.osNames;
    }

    public VersionRange[] getOSVersions() {
        if (this.osVersions == null) {
            return EMPTY_VERSIONRANGES;
        }
        return this.osVersions;
    }

    public String[] getProcessors() {
        if (this.processors == null) {
            return BundleDescriptionImpl.EMPTY_STRING;
        }
        return this.processors;
    }

    public BundleDescription getSupplier() {
        return this.supplier;
    }

    public int compareTo(Object other) {
        Version osversion;
        if (!(other instanceof NativeCodeDescription)) {
            return 1;
        }
        State containingState = this.getSupplier().getContainingState();
        if (containingState == null) {
            return 0;
        }
        Dictionary[] platformProps = containingState.getPlatformProperties();
        try {
            osversion = Version.parseVersion((String)platformProps[0].get("org.osgi.framework.os.version"));
        }
        catch (Exception exception) {
            osversion = Version.emptyVersion;
        }
        NativeCodeDescription otherDesc = (NativeCodeDescription)other;
        VersionRange[] thisRanges = this.getOSVersions();
        VersionRange[] otherRanges = otherDesc.getOSVersions();
        Version thisHighest = this.getHighestVersionMatch(osversion, thisRanges);
        Version otherHighest = this.getHighestVersionMatch(osversion, otherRanges);
        if (thisHighest.compareTo(otherHighest) < 0) {
            return -1;
        }
        return (this.getLanguages().length == 0 ? 0 : 1) - (otherDesc.getLanguages().length == 0 ? 0 : 1);
    }

    public boolean hasInvalidNativePaths() {
        return this.invalidNativePaths;
    }

    private Version getHighestVersionMatch(Version version, VersionRange[] ranges) {
        Version highest = Version.emptyVersion;
        int i = 0;
        while (i < ranges.length) {
            if (ranges[i].isIncluded(version) && highest.compareTo(ranges[i].getMinimum()) < 0) {
                highest = ranges[i].getMinimum();
            }
            ++i;
        }
        return highest;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String[] paths = this.getNativePaths();
        int i = 0;
        while (i < paths.length) {
            if (i > 0) {
                sb.append("; ");
            }
            sb.append(paths[i]);
            ++i;
        }
        String[] procs = this.getProcessors();
        int i2 = 0;
        while (i2 < procs.length) {
            sb.append("; ");
            sb.append("processor");
            sb.append('=');
            sb.append(procs[i2]);
            ++i2;
        }
        String[] oses = this.getOSNames();
        int i3 = 0;
        while (i3 < oses.length) {
            sb.append("; ");
            sb.append("osname");
            sb.append('=');
            sb.append(oses[i3]);
            ++i3;
        }
        VersionRange[] osRanges = this.getOSVersions();
        int i4 = 0;
        while (i4 < osRanges.length) {
            sb.append("; ");
            sb.append("osversion");
            sb.append("=\"");
            sb.append(osRanges[i4].toString());
            sb.append('\"');
            ++i4;
        }
        String[] langs = this.getLanguages();
        int i5 = 0;
        while (i5 < langs.length) {
            sb.append("; ");
            sb.append("language");
            sb.append('=');
            sb.append(langs[i5]);
            ++i5;
        }
        Filter f = this.getFilter();
        if (f != null) {
            sb.append("; ");
            sb.append("selection-filter");
            sb.append("=\"");
            sb.append(f.toString());
            sb.append('\"');
        }
        return sb.toString();
    }

    void setInvalidNativePaths(boolean invalidNativePaths) {
        this.invalidNativePaths = invalidNativePaths;
    }

    void setOSNames(String[] osNames) {
        this.osNames = osNames;
    }

    void setOSVersions(VersionRange[] osVersions) {
        this.osVersions = osVersions;
    }

    void setFilter(String filter) throws InvalidSyntaxException {
        this.filter = filter == null ? null : FrameworkUtil.createFilter(filter);
    }

    void setLanguages(String[] languages) {
        this.languages = languages;
    }

    void setNativePaths(String[] nativePaths) {
        this.nativePaths = nativePaths;
    }

    void setProcessors(String[] processors) {
        this.processors = processors;
    }

    void setSupplier(BundleDescription supplier) {
        this.supplier = supplier;
    }
}

