/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.render;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.seam.render.spi.TemplateResource;
import org.jboss.seam.render.template.CompiledTemplateResource;
import org.jboss.seam.render.template.nodes.DefineNode;
import org.jboss.seam.render.template.nodes.ExtendsNode;
import org.jboss.seam.render.template.nodes.IncludeNode;
import org.jboss.seam.render.template.nodes.InsertNode;
import org.jboss.seam.render.template.nodes.ParamNode;
import org.jboss.seam.render.template.resolver.TemplateResolutionException;
import org.jboss.seam.render.template.resolver.TemplateResolverFactory;
import org.jboss.seam.render.template.resource.FileTemplateResource;
import org.jboss.seam.render.template.resource.InputStreamTemplateResource;
import org.jboss.seam.render.template.resource.StringTemplateResource;
import org.jboss.seam.render.util.Assert;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.templates.SimpleTemplateRegistry;
import org.mvel2.templates.TemplateRegistry;
import org.mvel2.templates.res.Node;

public class TemplateCompiler {
    private final TemplateRegistry registry;
    private final VariableResolverFactory variableFactory;
    private final TemplateResolverFactory resolverFactory;
    private final Map<String, Class<? extends Node>> nodes = new HashMap<String, Class<? extends Node>>();

    @Inject
    public TemplateCompiler(VariableResolverFactory variableFactory) {
        this.variableFactory = variableFactory;
        this.resolverFactory = new TemplateResolverFactory();
        this.registry = new SimpleTemplateRegistry();
        this.addNode("param", ParamNode.class);
        this.addNode("extends", ExtendsNode.class);
        this.addNode("define", DefineNode.class);
        this.addNode("insert", InsertNode.class);
        this.addNode("include", IncludeNode.class);
    }

    public CompiledTemplateResource compileResource(String template) {
        return this.compile(new StringTemplateResource(template));
    }

    public CompiledTemplateResource compileResource(InputStream template) {
        return this.compile(new InputStreamTemplateResource(template));
    }

    public CompiledTemplateResource compileResource(File template) {
        return this.compile(new FileTemplateResource(template));
    }

    public CompiledTemplateResource compile(String path) throws TemplateResolutionException {
        TemplateResource resource = this.resolverFactory.resolve(path);
        return this.compile(resource);
    }

    public CompiledTemplateResource compile(String path, Map<String, Class<? extends Node>> nodes) throws TemplateResolutionException {
        TemplateResource resource = this.resolverFactory.resolve(path);
        return this.compile(resource, nodes);
    }

    public CompiledTemplateResource compile(TemplateResource<?> templateResource) throws TemplateResolutionException {
        Assert.notNull(templateResource, "Cannot compile a null TemplateResource.");
        Map<String, Class<? extends Node>> nodes = this.getNodes();
        return this.compile(templateResource, nodes);
    }

    public CompiledTemplateResource compile(TemplateResource<?> templateResource, Map<String, Class<? extends Node>> nodes) throws TemplateResolutionException {
        CompiledTemplateResource view = new CompiledTemplateResource(this, this.variableFactory, this.registry, templateResource, nodes);
        return view;
    }

    public CompiledTemplateResource compileRelative(TemplateResource<?> originResource, String relativePath) throws TemplateResolutionException {
        TemplateResource resource = this.resolverFactory.resolveRelative((TemplateResource)originResource, relativePath);
        return this.compile(resource);
    }

    public CompiledTemplateResource compileRelative(TemplateResource<?> originResource, String relativePath, Map<String, Class<? extends Node>> nodes) throws TemplateResolutionException {
        TemplateResource resource = this.resolverFactory.resolveRelative((TemplateResource)originResource, relativePath);
        return this.compile(resource, nodes);
    }

    public Map<String, Class<? extends Node>> getNodes() {
        return this.nodes;
    }

    public void addNode(String name, Class<? extends Node> type) {
        this.nodes.put(name, type);
    }

    public TemplateResolverFactory getTemplateResolverFactory() {
        return this.resolverFactory;
    }
}

