/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.render.template.resolver;

import java.io.File;
import org.jboss.seam.render.spi.TemplateResolver;
import org.jboss.seam.render.spi.TemplateResource;
import org.jboss.seam.render.template.resource.FileTemplateResource;
import org.jboss.seam.render.util.Assert;
import org.jboss.seam.render.util.Paths;

public class FileTemplateResolver
implements TemplateResolver<File> {
    @Override
    public TemplateResource<File> resolve(String path) {
        Assert.notNull(path, "Resource path must not be null.");
        File file = new File(path);
        if (this.validResource(file)) {
            return new FileTemplateResource(file, this);
        }
        return null;
    }

    @Override
    public TemplateResource<File> resolveRelative(TemplateResource<File> origin, String relativePath) {
        Assert.notNull(origin, "Origin resource must not be null.");
        Assert.notNull(relativePath, "Relative resource path must not be null.");
        relativePath = relativePath.trim();
        String path = origin.getPath();
        path = Paths.calculateRelativePath(path, relativePath);
        File file = new File(path);
        if (this.validResource(file)) {
            return new FileTemplateResource(file, this);
        }
        return null;
    }

    private boolean validResource(File file) {
        return file.exists() && file.isFile();
    }
}

