/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.render.template.resource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.jboss.seam.render.spi.TemplateResolver;
import org.jboss.seam.render.spi.TemplateResource;

public class StringTemplateResource
implements TemplateResource<String> {
    private final String template;
    private final TemplateResolver<String> resolvedBy;
    private String path = "";

    public StringTemplateResource(TemplateResolver<String> resolvedBy, String template, String path) {
        this.template = template;
        this.resolvedBy = resolvedBy;
        this.path = path;
    }

    public StringTemplateResource(String template, String path) {
        this.template = template;
        this.resolvedBy = null;
        this.path = path;
    }

    public StringTemplateResource(String template) {
        this.template = template;
        this.resolvedBy = null;
        this.path = null;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.template.getBytes());
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    public String getUnderlyingResource() {
        return this.template;
    }

    @Override
    public TemplateResolver<String> getResolvedBy() {
        return this.resolvedBy;
    }
}

