/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.render.util;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;

public abstract class BeanManagerUtils {
    public static <T> T getContextualInstance(BeanManager manager, Class<T> type) {
        CreationalContext context;
        Object result = null;
        Bean bean = manager.resolve(manager.getBeans(type, new Annotation[0]));
        if (bean != null && (context = manager.createCreationalContext((Contextual)bean)) != null) {
            result = manager.getReference(bean, type, context);
        }
        return (T)result;
    }

    public static void injectNonContextualInstance(BeanManager manager, Object instance) {
        if (instance != null) {
            CreationalContext creationalContext = manager.createCreationalContext(null);
            InjectionTarget injectionTarget = manager.createInjectionTarget(BeanManagerUtils.getAnnotatedType(manager, instance));
            injectionTarget.inject(instance, creationalContext);
        }
    }

    private static AnnotatedType<? extends Object> getAnnotatedType(BeanManager manager, Object instance) {
        AnnotatedType result = null;
        result = manager.createAnnotatedType(instance.getClass());
        return result;
    }
}

