/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.jboss.tools.common.meta.XAdoptManager;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XChild;
import org.jboss.tools.common.meta.XDependencies;
import org.jboss.tools.common.meta.XEntityRenderer;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.meta.action.XActionItem;
import org.jboss.tools.common.meta.action.XActionList;
import org.jboss.tools.common.meta.action.impl.XActionImpl;
import org.jboss.tools.common.meta.action.impl.XActionListImpl;
import org.jboss.tools.common.meta.impl.DefaultDependencies;
import org.jboss.tools.common.meta.impl.XAdoptWrapper;
import org.jboss.tools.common.meta.impl.XAttributeImpl;
import org.jboss.tools.common.meta.impl.XChildrenImpl;
import org.jboss.tools.common.meta.impl.XEntityRendererImpl;
import org.jboss.tools.common.meta.impl.XMetaDataLoader;
import org.jboss.tools.common.meta.impl.XMetaElementImpl;
import org.jboss.tools.common.meta.impl.XModelEntityExtensionImpl;
import org.jboss.tools.common.meta.impl.XModelMetaDataImpl;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.loaders.XObjectLoader;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.ModelFeatureFactory;
import org.jboss.tools.common.model.util.XModelObjectUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XModelEntityImpl
extends XMetaElementImpl
implements XModelEntity {
    public static boolean hideHelp = true;
    protected String module;
    protected XChildrenImpl children = new XChildrenImpl();
    protected XAttribute[] m_Attributes;
    protected XActionListImpl actions = new XActionListImpl();
    protected XEntityRenderer m_Renderer = null;
    protected String implementationClassName = null;
    protected String resolvedImplementationClassName = null;
    protected String m_GeneratorClassName = null;
    protected String loaderClassName = null;
    protected String resolvedLoaderClassName = null;
    protected String m_EditorClassName = null;
    protected XDependencies dependencies = new DefaultDependencies();
    protected XAdoptManager adopt = null;
    protected String xmlSubPath = null;
    protected Element element = null;
    static String UNRESOLVED = "UNRESOLVED";
    private HashMap<String, Integer> registered = new HashMap();
    private Properties xmlmap = null;
    static Set<String> unfoundEntities = null;

    protected XModelEntityImpl() {
    }

    public void setModule(String s) {
        this.module = s;
    }

    @Override
    public String getModule() {
        return this.module;
    }

    void setElement(Element element) {
        this.element = element;
        this.setName(element.getAttribute("name"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validate() {
        if (this.element == null) {
            return;
        }
        XModelEntityImpl xModelEntityImpl = this;
        synchronized (xModelEntityImpl) {
            if (this.element == null) {
                return;
            }
            this.load(this.element);
            this.element = null;
            XModelMetaDataImpl meta = (XModelMetaDataImpl)this.getMetaModel();
            ArrayList<XModelEntityExtensionImpl> es = meta.getExtensions().getExtensions(this.getName());
            if (es != null) {
                int i = 0;
                while (i < es.size()) {
                    this.merge(es.get(i));
                    ++i;
                }
                if (!hideHelp) {
                    this.addHelpAction();
                }
            }
        }
    }

    private void addHelpAction() {
        XActionListImpl list = this.actions;
        XActionItem item = this.actions.getItem("Properties");
        if (item instanceof XActionListImpl) {
            list = (XActionListImpl)item;
        }
        list.addActionItem(XActionImpl.getHelpAction());
    }

    @Override
    public XAttribute[] getAttributes() {
        return this.m_Attributes;
    }

    @Override
    public XAttribute getAttribute(String name) {
        int i = 0;
        while (i < this.m_Attributes.length) {
            if (this.m_Attributes[i].getName().equals(name)) {
                return this.m_Attributes[i];
            }
            ++i;
        }
        return null;
    }

    public void setAttributes(XAttribute[] attrs) {
        this.m_Attributes = attrs;
        if (attrs != null) {
            int i = 0;
            while (i < attrs.length) {
                XAttributeImpl ai = (XAttributeImpl)attrs[i];
                ai.setModelEntity(this);
                ++i;
            }
        }
    }

    @Override
    public Class getImplementingClass() {
        if (this.resolvedImplementationClassName == UNRESOLVED) {
            this.resolvedImplementationClassName = this.expand(this.implementationClassName, "Implementations");
        }
        if (this.resolvedImplementationClassName == null) {
            return null;
        }
        Class cls = ModelFeatureFactory.getInstance().getFeatureClass(this.resolvedImplementationClassName);
        if (cls == null) {
            this.resolvedImplementationClassName = null;
        }
        return cls;
    }

    @Override
    public boolean hasObjectImplementation() {
        return this.implementationClassName != null && this.implementationClassName.length() > 0;
    }

    @Override
    public XModelObject getObjectImplementation() {
        if (this.resolvedImplementationClassName == UNRESOLVED) {
            this.resolvedImplementationClassName = this.expand(this.implementationClassName, "Implementations");
        }
        if (this.resolvedImplementationClassName == null) {
            return null;
        }
        XModelObject o = ModelFeatureFactory.getInstance().createXModelObjectInstance(this.resolvedImplementationClassName);
        if (o == null) {
            this.resolvedImplementationClassName = null;
        }
        return o;
    }

    public void setImplementingClassName(String className) {
        if (className != null && className.length() == 0) {
            className = null;
        }
        this.implementationClassName = className;
        if (className != null) {
            this.resolvedImplementationClassName = UNRESOLVED;
        }
    }

    @Override
    public boolean hasObjectLoader() {
        return this.loaderClassName != null && this.loaderClassName.length() > 0;
    }

    @Override
    public XObjectLoader getObjectLoader() {
        if (this.resolvedLoaderClassName == UNRESOLVED) {
            this.resolvedLoaderClassName = this.expand(this.loaderClassName, "Loaders");
        }
        if (this.resolvedLoaderClassName == null) {
            return null;
        }
        Object o = ModelFeatureFactory.getInstance().createFeatureInstance(this.resolvedLoaderClassName);
        if (o == null) {
            return null;
        }
        if (!(o instanceof XObjectLoader)) {
            ModelPlugin.getPluginLog().logError("Model object loader" + this.resolvedLoaderClassName + " must implement " + XObjectLoader.class.getName());
            this.resolvedLoaderClassName = null;
            return null;
        }
        return (XObjectLoader)o;
    }

    public void setLoaderClassName(String className) {
        if (className != null && className.length() > 0) {
            this.loaderClassName = className;
            this.resolvedLoaderClassName = UNRESOLVED;
        }
    }

    @Override
    public String getEditorClassName() {
        this.m_EditorClassName = this.expand(this.m_EditorClassName, "ObjectEditor");
        return this.m_EditorClassName;
    }

    public void setEditorClassName(String className) {
        this.m_EditorClassName = className;
    }

    @Override
    public String getGeneratorClassName() {
        return this.m_GeneratorClassName;
    }

    public void setGeneratorClassName(String className) {
        this.m_GeneratorClassName = className;
    }

    @Override
    public XActionList getActionList() {
        if (!this.actions.isLoaded()) {
            this.actions.validate();
            if (!hideHelp) {
                this.addHelpAction();
            }
        }
        return this.actions;
    }

    @Override
    public XChild getChild(String entityName) {
        return this.children.getChild(entityName);
    }

    @Override
    public XChild[] getChildren() {
        return this.children.getChildren();
    }

    @Override
    public XEntityRenderer getRenderer() {
        return this.m_Renderer;
    }

    public void setRenderer(XEntityRenderer renderer) {
        this.m_Renderer = renderer;
    }

    @Override
    public String getXMLSubPath() {
        return this.xmlSubPath;
    }

    @Override
    public void load(Element element) {
        this.setName(element.getAttribute("name"));
        this.setImplementingClassName(element.getAttribute("ImplementingClass"));
        this.setLoaderClassName(element.getAttribute("ImplementationLoadingClass"));
        if (XMetaDataLoader.hasAttribute(element, "ObjectEditorClass")) {
            this.setEditorClassName(element.getAttribute("ObjectEditorClass"));
        }
        if (XMetaDataLoader.hasAttribute(element, "ImplementationGenerator")) {
            this.setGeneratorClassName(element.getAttribute("ImplementationGenerator"));
        }
        this.loadAttributes(element);
        this.children.load(element);
        this.setRenderer((XEntityRenderer)XMetaDataLoader.loadMetaElement(element, "XEntityRenderer", XEntityRendererImpl.class, true));
        if (XMetaDataLoader.hasAttribute(element, "AdoptManagerClass")) {
            this.setAdoptManager(element.getAttribute("AdoptManagerClass"));
        }
        this.loadDependencies(element);
        this.xmlSubPath = element.getAttribute("XMLSUBPATH");
        Element ei = XMetaDataLoader.getUniqueChild(element, "XActionItem");
        this.actions.setElement(ei);
        this.loadProperties(element);
    }

    private void loadAttributes(Element element) {
        Element att = XMetaDataLoader.getUniqueChild(element, "XModelAttributes");
        NodeList nl = att.getChildNodes();
        ArrayList<XAttributeImpl> list = new ArrayList<XAttributeImpl>();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.getNodeType() == 1) {
                Element e = (Element)n;
                String name = e.getNodeName();
                if ("XModelAttribute".equals(name)) {
                    XAttributeImpl attr = (XAttributeImpl)XMetaDataLoader.loadMetaElement(e, XAttributeImpl.class, false);
                    if (attr != null) {
                        list.add(attr);
                    }
                } else if ("XModelAttributeReference".equals(name)) {
                    XModelEntity entity;
                    String entityName = e.getAttribute("entity");
                    String attrName = e.getAttribute("name");
                    String attributes = e.getAttribute("attributes");
                    String[] atributeNames = new String[]{attrName};
                    if (atributeNames != null && attributes.length() > 0) {
                        atributeNames = XModelObjectUtil.asStringArray(attributes);
                    }
                    if ((entity = this.getMetaModel().getEntity(entityName)) != null) {
                        int k = 0;
                        while (k < atributeNames.length) {
                            XAttributeImpl attr = (XAttributeImpl)entity.getAttribute(atributeNames[k]);
                            if (attr != null) {
                                list.add(attr.copy());
                            } else if (ModelPlugin.isDebugEnabled()) {
                                ModelPlugin.getPluginLog().logInfo("Cannot find reference to attribute " + attrName + " of entity " + entityName);
                            }
                            ++k;
                        }
                    } else if (ModelPlugin.isDebugEnabled()) {
                        ModelPlugin.getPluginLog().logInfo("Cannot find reference to entity " + entityName);
                    }
                }
            }
            ++i;
        }
        this.setAttributes(list.toArray(new XAttributeImpl[0]));
    }

    private void loadDependencies(Element el) {
        XDependencies d;
        Element c = XMetaDataLoader.getUniqueChild(el, "XDependencies");
        XDependencies xDependencies = d = c == null ? null : (XDependencies)XMetaDataLoader.loadMetaElement(c, null, false);
        if (d != null) {
            this.dependencies = d;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append(this.getName());
        sb.append('\n');
        int i = 0;
        while (i < this.m_Attributes.length) {
            sb.append(" " + this.m_Attributes[i] + "\n");
            ++i;
        }
        return sb.toString();
    }

    @Override
    public boolean isVisible(XModelObject object, String attribute) {
        return this.dependencies.isVisible(object, attribute);
    }

    @Override
    public boolean isEditable(XModelObject object, String attribute) {
        return this.dependencies.isEditable(object, attribute);
    }

    @Override
    public void setDependentValues(XModelObject object, String attribute) {
        this.dependencies.setDependentValues(object, attribute);
    }

    @Override
    public XAdoptManager getAdoptManager() {
        return this.adopt;
    }

    public void setAdoptManager(String adoptclass) {
        if (adoptclass != null && adoptclass.length() > 0) {
            this.adopt = new XAdoptWrapper(adoptclass, this);
        }
    }

    void validateChildren() {
        this.children.validate(this.getMetaModel());
    }

    private void merge(XModelEntityExtensionImpl ext) {
        this.children.merge(ext.getChildren());
        this.actions.merge((XActionListImpl)ext.getActionList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPropertyIndex(String name, boolean register) {
        Integer io = this.registered.get(name);
        if (io == null) {
            if (!register) {
                return -1;
            }
            HashMap<String, Integer> hashMap = this.registered;
            synchronized (hashMap) {
                io = this.registered.get(name);
                if (io == null) {
                    io = this.registered.size();
                    this.registered.put(name, io);
                }
            }
        }
        return io;
    }

    @Override
    public int getPropertyCount() {
        return this.registered.size();
    }

    @Override
    public String getChildByXML(String xmlname) {
        if (this.xmlmap == null) {
            this.xmlmap = new Properties();
            XChild[] cs = this.children.getChildren();
            int i = 0;
            while (i < cs.length) {
                String n = cs[i].getName();
                XModelEntity e = this.getMetaModel().getEntity(n);
                if (e == null) {
                    if (unfoundEntities == null) {
                        unfoundEntities = new HashSet<String>();
                    }
                    if (!unfoundEntities.contains(n)) {
                        unfoundEntities.add(n);
                        ModelPlugin.getPluginLog().logInfo("getChildByXML: cannot find child entity " + n);
                    }
                } else {
                    String x = e.getXMLSubPath();
                    if (x != null && x.length() != 0) {
                        this.xmlmap.setProperty(x, n);
                    }
                }
                ++i;
            }
        }
        return this.xmlmap.getProperty(xmlname);
    }

    @Override
    public Set<String> getRequiredChildren() {
        return this.children.getRequiredChildren();
    }

    @Override
    public String testImplementation() {
        if (this.implementationClassName == null || this.implementationClassName.length() == 0) {
            return null;
        }
        String cn = this.expand(this.implementationClassName, "Implementations");
        if (cn == null) {
            return "cannot expand implementation " + this.implementationClassName;
        }
        Class cls = ModelFeatureFactory.getInstance().getFeatureClass(cn);
        if (cls == null) {
            return "cannot load implementation class " + cn;
        }
        try {
            Object h = cls.newInstance();
            if (!(h instanceof XModelObject)) {
                return "cannot reduce implementation to XModelObject";
            }
        }
        catch (InstantiationException instantiationException) {
            return "cannot create implementation object";
        }
        catch (IllegalAccessException illegalAccessException) {
            return "cannot create implementation object";
        }
        return null;
    }

    @Override
    public String testLoader() {
        if (this.loaderClassName == null || this.loaderClassName.length() == 0) {
            return null;
        }
        String cn = this.expand(this.loaderClassName, "Loaders");
        if (cn == null) {
            return "cannot expand loader " + this.loaderClassName;
        }
        Class cls = ModelFeatureFactory.getInstance().getFeatureClass(cn);
        if (cls == null) {
            return "cannot load loader class " + cn;
        }
        try {
            Object h = cls.newInstance();
            if (!(h instanceof XObjectLoader)) {
                return "cannot reduce loader to XObjectLoader";
            }
        }
        catch (InstantiationException instantiationException) {
            return "cannot create loader object";
        }
        catch (IllegalAccessException illegalAccessException) {
            return "cannot create loader object";
        }
        return null;
    }
}

