/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.impl.documentation;

import java.text.MessageFormat;
import java.util.Vector;
import org.jboss.tools.common.meta.impl.documentation.EntitiesValidator;
import org.jboss.tools.common.meta.impl.documentation.MetaValidator;
import org.jboss.tools.common.model.XModelObject;

class EntityDataValidator {
    EntityDataValidator() {
    }

    public void validate(XModelObject object) {
        XModelObject[] ds = object.getChildren("MetaEntityData");
        int i = 0;
        while (i < ds.length) {
            String en = ds[i].getAttributeValue("entity name");
            Vector<String> v = EntitiesValidator.entities.get(en);
            if (v == null) {
                MetaValidator.message(MessageFormat.format("Error in {0}: entity ''{1}'' not found.", MetaValidator.longid(object), en));
            } else {
                XModelObject[] as = ds[i].getChildren("MetaAttributeData");
                int j = 0;
                while (j < as.length) {
                    String an = as[j].getAttributeValue("attribute name");
                    if (!v.contains(an)) {
                        MetaValidator.message(MessageFormat.format("Error in {0}: attribute ''{1}'' not found in entity {2}.", MetaValidator.longid(object), an, en));
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

