/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.files.handlers;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public class TargetHolder {
    protected XAction action;
    XModelObject target;
    String path;
    IResource folder;
    String addPath = "";

    public void setAction(XAction action) {
        this.action = action;
    }

    public void revalidate(String newPath) {
        if (newPath == this.path || newPath != null && newPath.equals(this.path)) {
            return;
        }
        this.path = newPath;
        this.addPath = "";
        this.folder = this.path == null ? null : ModelPlugin.getWorkspace().getRoot().findMember(this.path);
        this.target = EclipseResourceUtil.getObjectByResource(this.folder);
        if (!(this.path == null || this.folder != null && this.folder.exists())) {
            int q;
            String p = this.path.replace('\\', '/');
            String ap = "";
            while ((q = p.lastIndexOf(47)) >= 0) {
                ap = String.valueOf(p.substring(q)) + ap;
                p = p.substring(0, q);
                this.folder = ModelPlugin.getWorkspace().getRoot().findMember(p);
                if (this.folder == null || !this.folder.exists()) continue;
                this.addPath = ap;
                if (this.addPath.endsWith("/")) {
                    this.addPath = this.addPath.substring(0, this.addPath.length() - 1);
                }
                this.target = EclipseResourceUtil.createObjectForResource(this.folder);
                break;
            }
        } else if (this.target == null && this.folder != null && this.folder.exists()) {
            this.target = EclipseResourceUtil.createObjectForResource(this.folder);
        } else if (this.target != null && "FileSystems".equals(this.target.getModelEntity().getName())) {
            this.target = EclipseResourceUtil.findFileSystem(this.folder, this.target.getModel());
            if (this.target == null) {
                this.target = EclipseResourceUtil.createObjectForResource(this.folder);
            }
        }
    }

    public void saveLastPath() {
        if (this.path == null || this.folder == null) {
            return;
        }
        QualifiedName n = new QualifiedName("", String.valueOf(this.action.getName()) + "_lastPath");
        try {
            this.folder.getProject().setPersistentProperty(n, this.path);
        }
        catch (CoreException e) {
            ModelPlugin.getPluginLog().logError("CreateFileSuppport:TargetHolder:saveLastPath:" + e.getMessage());
        }
    }
}

