/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.BodySource;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.util.FileUtil;

class EclipseFileBodySource
implements BodySource {
    IFile ef = null;
    File f;

    public EclipseFileBodySource(IFile ef, File f) {
        this.ef = ef;
        this.f = f;
    }

    @Override
    public String get() {
        String encoding = null;
        if (this.ef != null && this.ef.exists()) {
            encoding = FileUtil.getEncoding((IFile)this.ef);
        }
        if (encoding == null) {
            encoding = ResourcesPlugin.getEncoding();
        }
        try {
            boolean isUTF8BOM = ModelPlugin.isUTF8BOM(encoding, this.ef);
            if (!isUTF8BOM) {
                return FileUtil.readFileWithEncodingCheck((File)this.f, (String)encoding);
            }
            return ModelPlugin.getContent(this.ef.getContents(), encoding, true);
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.jboss.tools.common.model", 0, e.getLocalizedMessage(), (Throwable)e);
            ModelPlugin.getDefault().getLog().log((IStatus)status);
            return null;
        }
    }

    @Override
    public boolean write(Object object) {
        if (!(object instanceof XModelObject)) {
            return false;
        }
        XModelObject o = (XModelObject)object;
        try {
            String encoding = null;
            if (this.ef != null && this.ef.exists()) {
                encoding = FileUtil.getEncoding((IFile)this.ef);
            }
            if (encoding == null) {
                encoding = ResourcesPlugin.getEncoding();
            }
            XModelObjectLoaderUtil.saveBody(this.f, o, encoding);
            o.setModified(false);
            XModelObject p = o.getParent();
            while (p != null && p.getFileType() < 2) {
                p = p.getParent();
            }
            if (p instanceof FolderImpl) {
                ((FolderImpl)p).getFileSystem().getPeer().register(this.f);
            }
            this.ef.refreshLocal(2, null);
        }
        catch (CoreException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
        }
        return true;
    }
}

