/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import org.jboss.tools.common.model.XFilteredTreeConstraint;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;

public class FileSystemsTreeConstraint
implements XFilteredTreeConstraint {
    String excludeExtensions = ".project.classpath.";
    private static String[] names = new String[]{"CVS", ".svn"};

    @Override
    public void update(XModel model) {
    }

    @Override
    public boolean accepts(XModelObject object) {
        String entity = object.getModelEntity().getName();
        if ("FileAnyAuxiliary".equals(entity)) {
            return false;
        }
        if (object.getFileType() == 3) {
            String s = object.getAttributeValue("info");
            return s == null || s.indexOf("hidden=yes") < 0;
        }
        if (object.getFileType() == 1) {
            String ext = "." + object.getAttributeValue("extension") + ".";
            if (this.excludeExtensions.indexOf(ext) >= 0) {
                return false;
            }
            if (".rule-sets".equals(object.getAttributeValue("name"))) {
                return false;
            }
        } else if (object.getFileType() == 2) {
            String[] ns = this.getHiddenFolderNames();
            String n = object.get("NAME");
            int i = 0;
            while (i < ns.length) {
                if (ns[i].equalsIgnoreCase(n)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public boolean isHidingAllChildren(XModelObject object) {
        return object.getFileType() > 0 && "true".equals(object.get("overlapped"));
    }

    @Override
    public boolean isHidingSomeChildren(XModelObject object) {
        if (object.getModelEntity().getName().equals("FileSystems")) {
            return true;
        }
        return object.getFileType() >= 2;
    }

    protected String[] getHiddenFolderNames() {
        return names;
    }
}

