/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.undo;

import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.undo.XTransactionUndo;
import org.jboss.tools.common.model.undo.XUndoItem;
import org.jboss.tools.common.model.undo.XUndoList;
import org.jboss.tools.common.model.undo.XUndoable;
import org.jboss.tools.common.model.undo.XUndoableImpl;
import org.jboss.tools.common.model.undo.XUndoableT;

public class XUndoManager {
    private XModel model = null;
    private XUndoableImpl start;
    private XUndoableImpl current;
    private int transaction = -1;
    private Object listener = null;

    public XUndoManager() {
        this.reset();
    }

    public void setModel(XModel model) {
        this.model = model;
    }

    public void reset() {
        this.current = this.start = new XUndoableT(null);
        this.fire();
    }

    public void undo() {
        if (!this.canUndo()) {
            return;
        }
        this.current.undo();
        this.current = this.current.prev();
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        this.current = this.current.next();
        this.current.redo();
    }

    public boolean canUndo() {
        return this.current != this.start && this.current.canUndo();
    }

    public boolean canRedo() {
        return this.current.next() != null && this.current.next().canRedo();
    }

    public void addUndoable(XUndoable u) {
        XUndoableImpl w;
        XUndoableImpl xUndoableImpl = w = u instanceof XUndoableImpl ? (XUndoableImpl)u : new XUndoableT(u);
        if (this.current.merge(w)) {
            return;
        }
        this.current.setNext(w);
        this.current = w;
        if (this.transaction >= 0) {
            ++this.transaction;
        }
        this.reduce();
        this.fire();
    }

    private void reduce() {
        if (this.transaction >= 0) {
            return;
        }
        int capacity = 10;
        XModelObject root = this.model.getRoot("Preferences");
        if (root != null) {
            String c = root.getAttributeValue("undo capacity");
            try {
                capacity = Integer.parseInt(c);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (capacity == 0) {
            this.start.setNext(null);
            this.current = this.start;
            return;
        }
        int i = 0;
        XUndoableImpl c = this.current;
        while (true) {
            ++i;
            if (c == this.start) {
                return;
            }
            if (i >= capacity) {
                this.start.setNext(c);
                return;
            }
            c = c.prev();
        }
    }

    public XUndoList getList() {
        XUndoList list = new XUndoList(this);
        XUndoableImpl u = this.start;
        int s = -1;
        if (u == this.current) {
            list.setCurrent(s);
        }
        while (u.next() != null) {
            u = u.next();
            ++s;
            if (u == this.current) {
                list.setCurrent(s);
            }
            XUndoItem item = new XUndoItem(u.getDescription());
            item.setIcons(u.icons());
            list.add(item);
        }
        return list;
    }

    public void beginTransaction() {
        this.transaction = 0;
    }

    public int getTransactionStatus() {
        return this.transaction;
    }

    public void commitTransaction() {
        int i = 0;
        while (i < this.transaction) {
            this.current = this.current.prev();
            ++i;
        }
        this.current.setNext(null);
        this.transaction = -1;
    }

    public void rollbackTransaction() {
        int i = 0;
        while (i < this.transaction) {
            this.undo();
            ++i;
        }
        this.current.setNext(null);
        this.transaction = -1;
        this.fire();
    }

    public void rollbackTransactionInProgress() {
        if (this.current.next() != null || !(this.current instanceof XTransactionUndo)) {
            return;
        }
        XTransactionUndo t = (XTransactionUndo)this.current;
        if (!t.isInProgress()) {
            return;
        }
        if (t.canUndo()) {
            t.undo();
        }
        this.current = t.prev();
        this.current.setNext(null);
        this.fire();
    }

    public void addListener(Object listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fire() {
        if (this.listener == null) {
            return;
        }
        Object object = this.listener;
        synchronized (object) {
            this.listener.notify();
        }
    }
}

