/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.util;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jboss.tools.common.model.XModelObject;

public class NamespaceMapping {
    public static String ATTR_NAMESPACE_MAPPING = "namespaceMapping";
    Map<String, String> defaultToActual = new HashMap<String, String>();
    Map<String, String> actualToDefault = new HashMap<String, String>();
    Map<String, String> defaultToURI = new HashMap<String, String>();
    Map<String, String> defaultToActualCache = new HashMap<String, String>();
    Map<String, String> actualToDefaultCache = new HashMap<String, String>();

    public void addNamespace(String defaultNamespace, String actualNamespace, String uri) {
        this.defaultToActual.put(defaultNamespace, actualNamespace);
        this.actualToDefault.put(actualNamespace, defaultNamespace);
        this.defaultToURI.put(defaultNamespace, uri);
    }

    public String getActualNamespace(String defaultNamespace) {
        return this.defaultToActual.get(defaultNamespace);
    }

    public String getDefaultNamespace(String actualNamespace) {
        return this.actualToDefault.get(actualNamespace);
    }

    public String getURIForDefaultNamespace(String defaultNamespace) {
        return defaultNamespace == null ? null : this.defaultToURI.get(defaultNamespace);
    }

    public String getURIForActualNamespace(String actualNamespace) {
        String defaultNamespace = this.getDefaultNamespace(actualNamespace);
        return this.getURIForDefaultNamespace(defaultNamespace);
    }

    public String convertToDefault(String name) {
        if (name.indexOf(58) < 0) {
            return name;
        }
        String value = this.actualToDefaultCache.get(name);
        if (value != null) {
            return value;
        }
        int i = name.indexOf(58);
        String a = name.substring(0, i);
        String d = this.getDefaultNamespace(a);
        value = d == null || a.equals(d) ? name : String.valueOf(d) + name.substring(i);
        this.defaultToActualCache.put(name, value);
        return value;
    }

    public String convertToActual(String name) {
        if (name.indexOf(58) < 0) {
            return name;
        }
        String value = this.defaultToActualCache.get(name);
        if (value != null) {
            return value;
        }
        StringBuffer res = new StringBuffer();
        if (name.indexOf(124) >= 0) {
            StringTokenizer st = new StringTokenizer(name, "|");
            int i = 0;
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                if (i > 0) {
                    res.append('|');
                }
                t = this.convertToActual(t);
                res.append(t);
                ++i;
            }
        } else if (name.indexOf(46) >= 0) {
            StringTokenizer st = new StringTokenizer(name, ".");
            int i = 0;
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                if (i > 0) {
                    res.append('.');
                }
                t = this.convertToActual(t);
                res.append(t);
                ++i;
            }
        } else {
            int i = name.indexOf(58);
            String d = name.substring(0, i);
            String a = this.getActualNamespace(d);
            if (a == null || a.equals(name)) {
                res.append(name);
            } else {
                res.append(a).append(name.substring(i));
            }
        }
        value = res.toString();
        this.defaultToActualCache.put(name, value);
        return value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (String d : this.defaultToActual.keySet()) {
            String a = this.defaultToActual.get(d);
            String u = this.defaultToURI.get(d);
            sb.append(d).append(' ').append(a).append(' ').append(u).append(' ');
        }
        return sb.toString();
    }

    public static NamespaceMapping load(XModelObject file) {
        String nms = file.get(ATTR_NAMESPACE_MAPPING);
        return nms == null ? null : NamespaceMapping.load(nms);
    }

    public static NamespaceMapping load(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        NamespaceMapping m = new NamespaceMapping();
        StringTokenizer st = new StringTokenizer(s, " ");
        while (st.hasMoreTokens()) {
            String d = st.nextToken();
            String a = st.hasMoreTokens() ? st.nextToken() : d;
            String u = st.hasMoreTokens() ? st.nextToken() : "http://";
            m.addNamespace(d, a, u);
        }
        return m;
    }
}

