/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.IProblemChangedListener;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.jboss.tools.common.editor.ObjectMultiPageEditor;

public class ObjectEditorErrorTickUpdater
implements IProblemChangedListener {
    private ObjectMultiPageEditor fJavaEditor;
    private JavaUILabelProvider fLabelProvider;

    public ObjectEditorErrorTickUpdater(ObjectMultiPageEditor editor) {
        Assert.isNotNull((Object)((Object)editor));
        this.fJavaEditor = editor;
        this.fLabelProvider = new JavaUILabelProvider(0L, 2);
        this.fLabelProvider.addLabelDecorator((ILabelDecorator)new ProblemsLabelDecorator(null));
        JavaPlugin.getDefault().getProblemMarkerManager().addListener((IProblemChangedListener)this);
    }

    public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        IFile resource;
        if (!isMarkerChange) {
            return;
        }
        IEditorInput input = this.fJavaEditor.getEditorInput();
        if (input instanceof IFileEditorInput && (resource = ((IFileEditorInput)input).getFile()) != null) {
            int i = 0;
            while (i < changedResources.length) {
                if (changedResources[i].equals((Object)resource)) {
                    this.updateEditorImage(resource);
                }
                ++i;
            }
        }
    }

    public void updateEditorImage(IFile jelement) {
        Image titleImage = this.fJavaEditor.getTitleImage();
        if (titleImage == null) {
            return;
        }
        Image newImage = this.fLabelProvider.getImage((Object)jelement);
        if (titleImage != newImage) {
            this.postImageChange(newImage);
        }
    }

    private void postImageChange(final Image newImage) {
        Shell shell = this.fJavaEditor.getEditorSite().getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    ObjectEditorErrorTickUpdater.this.fJavaEditor.updatedTitleImage(newImage);
                }
            });
        }
    }

    public void dispose() {
        this.fLabelProvider.dispose();
        JavaPlugin.getDefault().getProblemMarkerManager().removeListener((IProblemChangedListener)this);
    }
}

