/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.editor;

import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.jboss.tools.common.core.resources.XModelObjectEditorInput;
import org.jboss.tools.common.editor.ObjectMultiPageEditor;
import org.jboss.tools.common.meta.action.SpecialWizard;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.Preference;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.editor.IModelObjectEditorInput;

public class OpenEditorWizard
implements SpecialWizard {
    Properties p;

    public void setObject(Object object) {
        this.p = (Properties)object;
    }

    public int execute() {
        IModelObjectEditorInput input;
        String id;
        IWorkbenchPage workbenchPage;
        IEditorPart editor;
        block27: {
            XModelObject object;
            block26: {
                editor = null;
                object = (XModelObject)this.p.get("object");
                workbenchPage = this.getWorkbenchPage();
                if (workbenchPage != null) break block26;
                return 0;
            }
            id = object.getModelEntity().getEditorClassName();
            if ("FileXML".equals(object.getModelEntity().getName())) {
                id = null;
            }
            if (id != null && (id.length() == 0 || id.equals("DefaultEditor"))) {
                id = null;
            } else {
                boolean b = "yes".equals(PreferenceModelUtilities.getPreferenceModel().getByPath(Preference.EDITOR_PATH).getAttributeValue("useRedHatEditors"));
                if (!b) {
                    id = null;
                }
            }
            input = XModelObjectEditorInput.createInstance(object);
            if (input == null) {
                throw new IllegalStateException("Cannot find resource for object " + object.getPresentationString());
            }
            if (!(input instanceof IFileEditorInput)) break block27;
            IFileEditorInput fei = (IFileEditorInput)input;
            IFile f = fei.getFile();
            if (f != null && !f.isSynchronized(2)) {
                try {
                    f.getParent().refreshLocal(2, null);
                }
                catch (CoreException e) {
                    ModelUIPlugin.getPluginLog().logError((Throwable)e);
                }
            }
            if (f != null && f.exists()) break block27;
            ServiceDialog d = object.getModel().getService();
            String pathData = f == null ? object.getPath() : f.getFullPath();
            String message = MessageFormat.format("The file {0} was removed externally.", pathData);
            d.showDialog("Warning", message, new String[]{"Close"}, null, 2);
            object.getModel().update();
            return 1;
        }
        try {
            if ("true".equals(this.p.getProperty("onlySelectIfOpen"))) {
                editor = workbenchPage.findEditor((IEditorInput)input);
                if (editor != null) {
                    workbenchPage.bringToTop((IWorkbenchPart)editor);
                }
            } else if (id == null) {
                if (input instanceof IFileEditorInput) {
                    IFile f = ((IFileEditorInput)input).getFile();
                    IDE.setDefaultEditor((IFile)f, null);
                    IEditorDescriptor d = IDE.getEditorDescriptor((IFile)f);
                    if (d != null) {
                        id = d.getId();
                    }
                    editor = id != null ? IDE.openEditor((IWorkbenchPage)workbenchPage, (IFile)f, (String)id, (boolean)true) : IDE.openEditor((IWorkbenchPage)workbenchPage, (IFile)f, (boolean)true);
                } else {
                    if (id == null) {
                        IEditorDescriptor d = IDE.getEditorDescriptor((String)input.getName());
                        if (d != null) {
                            id = d.getId();
                        }
                        if (id == null) {
                            id = "org.eclipse.ui.DefaultTextEditor";
                        }
                    }
                    editor = workbenchPage.openEditor((IEditorInput)input, id);
                }
            } else {
                editor = workbenchPage.openEditor((IEditorInput)input, id);
            }
            if (this.p != null && editor != null) {
                this.p.put("editor", editor);
            }
            if (this.p != null && "true".equals(this.p.get("toErrorTab")) && editor instanceof ObjectMultiPageEditor) {
                ObjectMultiPageEditor m = (ObjectMultiPageEditor)editor;
                m.activateErrorTab();
            }
        }
        catch (XModelException e) {
            this.p.put("exception", (Object)e);
            return 1;
        }
        catch (PartInitException e) {
            this.p.put("exception", (Object)e);
            return 1;
        }
        return 0;
    }

    private IWorkbenchPage getWorkbenchPage() {
        ModelUIPlugin plugin = ModelUIPlugin.getDefault();
        IWorkbench workbench = plugin == null ? null : plugin.getWorkbench();
        IWorkbenchWindow window = workbench == null ? null : workbench.getActiveWorkbenchWindow();
        return window == null ? null : window.getActivePage();
    }
}

