/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.action;

import java.util.ArrayList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.ui.ModelUIMessages;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.action.CommandBarLayout;
import org.jboss.tools.common.model.ui.action.CommandBarListener;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;

public class CommandBar {
    public static final String SEPARATOR = "_SEPARATOR_";
    public static String FILL = " ";
    CommandBarListener listener = null;
    Composite control = null;
    CommandBarLayout layout = new CommandBarLayout();
    ArrayList<ButtonDescriptor> buttons = new ArrayList();
    String defaultCommand = null;
    boolean isMnemonicEnabled = false;
    IWidgetSettings settings = null;

    public void dispose() {
        if (this.buttons != null) {
            this.buttons.clear();
        }
        this.buttons = null;
        this.listener = null;
        if (this.control != null) {
            if (!this.control.isDisposed()) {
                this.control.dispose();
            }
            this.control = null;
        }
    }

    public void addCommandBarListener(CommandBarListener listener) {
        this.listener = listener;
    }

    public CommandBarLayout getLayout() {
        return this.layout;
    }

    public void setLayout(CommandBarLayout layout) {
        this.layout = layout;
    }

    public void setWidgetSettings(IWidgetSettings settings) {
        this.settings = settings;
    }

    public Control createControl(Composite parent) {
        if (this.layout.asToolBar) {
            this.control = new ToolBar(parent, 0x800000 | this.layout.direction);
        } else {
            this.control = new Composite(parent, 0);
            this.control.setBackgroundMode(1);
            this.control.setLayout((Layout)this.layout);
        }
        this.update();
        return this.control;
    }

    public Control getControl() {
        return this.control;
    }

    public void setCommands(String[] commands) {
        ButtonDescriptor d = null;
        int i = 0;
        while (i < commands.length) {
            if (this.buttons.size() > i) {
                d = this.buttons.get(i);
            } else {
                d = new ButtonDescriptor();
                this.buttons.add(d);
            }
            d.command = commands[i];
            if (ModelUIMessages.CommandBar_OK.equalsIgnoreCase(commands[i]) || ModelUIMessages.CommandBar_Finish.equalsIgnoreCase(commands[i]) || ModelUIMessages.CommandBar_Next.equalsIgnoreCase(commands[i]) || ModelUIMessages.CommandBar_NextArrow.equalsIgnoreCase(commands[i]) || ModelUIMessages.CommandBar_Run.equalsIgnoreCase(commands[i])) {
                this.defaultCommand = commands[i];
            }
            ++i;
        }
        i = this.buttons.size() - 1;
        while (i >= commands.length) {
            d = this.buttons.remove(i);
            d.dispose();
            --i;
        }
    }

    public void setMnemonicEnabled(boolean b) {
        if (this.isMnemonicEnabled == b) {
            return;
        }
        this.isMnemonicEnabled = b;
        this.update();
    }

    public void setImage(String command, Image image) {
        ButtonDescriptor d = this.getButtonForCommand(command);
        if (d != null) {
            d.image = image;
        }
    }

    public void setEnabled(String command, boolean enabled) {
        ButtonDescriptor d = this.getButtonForCommand(command);
        if (d != null) {
            d.setEnabled(enabled);
        }
    }

    public void disable() {
        int i = 0;
        while (i < this.buttons.size()) {
            ButtonDescriptor d = this.getButtonAt(i);
            d.setEnabled(false);
            ++i;
        }
    }

    public boolean isEnabled(String command) {
        ButtonDescriptor d = this.getButtonForCommand(command);
        return d != null && d.enabled;
    }

    public void rename(String oldCommand, String newCommand) {
        ButtonDescriptor d = this.getButtonForCommand(oldCommand);
        if (d != null) {
            d.rename(newCommand);
        }
    }

    public void setDefaultCommand(String command) {
        this.defaultCommand = command;
        this.update();
    }

    ButtonDescriptor getButtonForCommand(String command) {
        int i = 0;
        while (i < this.buttons.size()) {
            ButtonDescriptor d = this.getButtonAt(i);
            if (command.equals(d.command)) {
                return d;
            }
            ++i;
        }
        return null;
    }

    public void update() {
        int i = 0;
        while (i < this.buttons.size()) {
            this.getButtonAt(i).update();
            ++i;
        }
    }

    ButtonDescriptor getButtonAt(int i) {
        return i < 0 || i >= this.buttons.size() ? null : this.buttons.get(i);
    }

    class ButtonDescriptor
    implements SelectionListener {
        Widget button;
        String command;
        Image image = null;
        boolean enabled = true;

        ButtonDescriptor() {
        }

        public void createControl(Composite parent) {
            if (this.button != null) {
                this.button.dispose();
            }
            if (!CommandBar.SEPARATOR.equals(this.command)) {
                if (CommandBar.this.layout.asToolBar) {
                    this.button = new ToolItem((ToolBar)parent, 8);
                    ((ToolItem)this.button).addSelectionListener((SelectionListener)this);
                } else {
                    int style;
                    int n = style = CommandBar.this.settings == null ? 8 : CommandBar.this.settings.getStyle("Button.Style");
                    if (style == -1) {
                        style = 0;
                    }
                    if (style == 0) {
                        style = 8;
                    }
                    this.button = new Button(parent, style);
                    if (CommandBar.this.settings != null) {
                        Color bg = CommandBar.this.settings.getColor("Button.Background");
                        Color fg = CommandBar.this.settings.getColor("Button.Foreground");
                        Font font = CommandBar.this.settings.getFont("Button.Font");
                        ((Control)this.button).setBackground(bg);
                        ((Control)this.button).setForeground(fg);
                        ((Control)this.button).setFont(font);
                    }
                    ((Button)this.button).addSelectionListener((SelectionListener)this);
                }
                this._update();
            } else if (CommandBar.this.layout.asToolBar) {
                this.button = new ToolItem((ToolBar)parent, 2);
            }
        }

        public void update() {
            if (this.button == null || this.button.isDisposed()) {
                if (CommandBar.this.control != null && !CommandBar.this.control.isDisposed()) {
                    this.createControl(CommandBar.this.control);
                }
                return;
            }
            this._update();
        }

        protected void _update() {
            this._updateCommand();
            this._updateEnabled();
            if (this.image != null) {
                if (CommandBar.this.layout.asToolBar) {
                    ((ToolItem)this.button).setImage(this.image);
                } else {
                    ((Button)this.button).setImage(this.image);
                }
            }
            this._updateDefault();
        }

        void _updateEnabled() {
            if (this.button != null && !this.button.isDisposed()) {
                if (CommandBar.this.layout.asToolBar) {
                    ((ToolItem)this.button).setEnabled(this.enabled);
                } else {
                    ((Button)this.button).setEnabled(this.enabled);
                }
            }
        }

        void _updateCommand() {
            if (this.button == null || this.button.isDisposed()) {
                return;
            }
            if (CommandBar.this.layout.iconsOnly) {
                if (CommandBar.this.layout.asToolBar) {
                    ((ToolItem)this.button).setToolTipText(this.getText(false));
                    ((ToolItem)this.button).setText("");
                } else {
                    ((Button)this.button).setToolTipText(this.getText(false));
                    ((Button)this.button).setText("");
                }
                if (this.image != null) {
                    if (CommandBar.this.layout.asToolBar) {
                        ((ToolItem)this.button).setImage(this.image);
                    } else {
                        ((Button)this.button).setImage(this.image);
                    }
                }
            } else if (CommandBar.this.layout.asToolBar) {
                ((ToolItem)this.button).setToolTipText(null);
                ((ToolItem)this.button).setText(this.getText(CommandBar.this.isMnemonicEnabled));
            } else {
                ((Button)this.button).setToolTipText(null);
                ((Button)this.button).setText(this.getText(CommandBar.this.isMnemonicEnabled));
            }
        }

        String getText(boolean withMnemonic) {
            if (withMnemonic) {
                return this.command;
            }
            int i = this.command.indexOf(38);
            return i < 0 ? this.command : String.valueOf(this.command.substring(0, i)) + this.command.substring(i + 1);
        }

        void _updateDefault() {
            if (this.command.equalsIgnoreCase(CommandBar.this.defaultCommand) && this.button != null && !this.button.isDisposed() && !CommandBar.this.layout.asToolBar) {
                ((Button)this.button).getShell().setDefaultButton((Button)this.button);
            }
        }

        public void setEnabled(boolean enabled) {
            if (this.enabled == enabled) {
                return;
            }
            this.enabled = enabled;
            this._updateEnabled();
        }

        public void rename(String newCommand) {
            if (newCommand.equals(this.command)) {
                return;
            }
            this.command = newCommand;
            this._updateCommand();
        }

        public void setDefault() {
            this._updateDefault();
        }

        public void widgetSelected(SelectionEvent e) {
            if (CommandBar.this.listener != null) {
                try {
                    CommandBar.this.listener.action(this.command);
                }
                catch (XModelException e1) {
                    ModelUIPlugin.getPluginLog().logError((Throwable)e1);
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void dispose() {
            if (this.button == null || this.button.isDisposed()) {
                return;
            }
            this.button.dispose();
            this.button = null;
        }
    }
}

