/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.action;

import java.util.Properties;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.common.meta.action.SignificanceMessageFactory;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.XActionItem;
import org.jboss.tools.common.meta.action.XRedirect;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.ActionDeclinedException;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.action.ActionX;
import org.jboss.tools.common.model.ui.action.XModelObjectActionItem;
import org.jboss.tools.common.model.ui.wizards.OneStepWizard;

public class XModelObjectAction
extends XModelObjectActionItem {
    protected XAction action;
    ActionX eclipseAction;

    public XModelObjectAction(XAction action, XModelObject object, XModelObject[] targets, Object environment) {
        super((XActionItem)action, object, targets, environment);
        this.action = action;
        this.eclipseAction = new ActionX(this);
    }

    public Action getEclipseAction() {
        return this.eclipseAction;
    }

    public Shell getShell() {
        if (this.shell != null) {
            return this.shell;
        }
        try {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public void actionPerformed() {
        String wizardName;
        XAction runAction = this.action;
        XModelObject runObject = this.object;
        XRedirect redirect = this.action.getRedirect();
        XAction redirectAction = null;
        XModelObject redirectObject = null;
        while (redirect != null) {
            redirectAction = redirect.getRedirectAction(runObject);
            redirectObject = redirect.getRedirectSource(runObject);
            XRedirect xRedirect = redirect = redirectAction == null ? null : redirectAction.getRedirect();
            if (redirect == null) continue;
            runObject = redirectObject;
        }
        if (redirectAction != null && redirectObject != null) {
            runAction = redirectAction;
            runObject = redirectObject;
        }
        if (this.action.getSignificantFlag(this.object)) {
            String message = String.valueOf(SignificanceMessageFactory.getInstance().getMessage(this.action, this.object, this.targets)) + "?";
            MessageDialog d = new MessageDialog(this.getShell(), "Confirmation", null, message, 3, new String[]{"OK", "Cancel"}, 0);
            int m = d.open();
            if (m != 0) {
                return;
            }
        }
        if ((wizardName = runAction.getWizardClassName()) == null || wizardName.equals("")) {
            this.action.getEntityData(this.object);
            try {
                Properties p = this.prepareProperties();
                if (p == null) {
                    p = new Properties();
                }
                if (this.getShell() != null) {
                    p.put("shell", this.getShell());
                }
                if (this.targets == null) {
                    this.action.executeHandler(this.object, p);
                }
                this.action.executeHandler(this.object, this.targets, p);
            }
            catch (ActionDeclinedException actionDeclinedException) {
                return;
            }
            catch (XModelException e2) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e2);
            }
        } else {
            runAction.getEntityData(runObject);
            OneStepWizard w = new OneStepWizard();
            Properties p = this.prepareProperties();
            if (p == null) {
                p = new Properties();
            }
            p.put("action", runAction);
            p.put("object", runObject);
            if (this.getShell() != null) {
                p.put("shell", this.getShell());
            }
            w.setObject(p);
            w.execute();
        }
    }

    protected Properties prepareProperties() {
        if (this.environment == null) {
            return null;
        }
        if (this.environment instanceof Properties) {
            return (Properties)this.environment;
        }
        if (!(this.environment instanceof Object[])) {
            return null;
        }
        Object[] os = (Object[])this.environment;
        int i = 0;
        while (i < os.length) {
            if (os[i] instanceof Properties) {
                return (Properties)os[i];
            }
            ++i;
        }
        return null;
    }

    public void createMenuItem(Menu menu) {
        boolean hidden;
        boolean enabled = this.targets == null ? this.action.isEnabled(this.object) : this.action.isEnabled(this.object, this.targets);
        boolean bl = hidden = this.action.hide(enabled) || !enabled && this.targets != null;
        if (hidden) {
            return;
        }
        MenuItem item = new MenuItem(menu, 64);
        item.setAccelerator(this.eclipseAction.getAccelerator());
        item.addSelectionListener((SelectionListener)new AL());
        item.setText(this.eclipseAction.getText());
        item.setEnabled(this.eclipseAction.isEnabled());
        item.setImage(this.eclipseAction.getImage());
    }

    class AL
    implements SelectionListener {
        AL() {
        }

        public void widgetSelected(SelectionEvent e) {
            XModelObjectAction.this.actionPerformed();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

