/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.action.file;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public class ModelResourceActionDelegate
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate {
    IResource resource = null;
    protected XModelObject object;
    protected List<XModelObject> objects = new ArrayList<XModelObject>();
    protected boolean isWindowAction;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (action.isEnabled()) {
            this.doRun();
        }
    }

    private void doRun() {
        Properties p = new Properties();
        this.initProperties(p);
        if (this.objects.size() < 2) {
            XActionInvoker.invoke((String)this.getActionPath(), (XModelObject)this.object, (Properties)p);
        } else {
            XModelObject[] os = this.objects.toArray(new XModelObject[0]);
            XActionInvoker.invoke((String)this.getActionPath(), (XModelObject)this.object, (XModelObject[])os, (Properties)p);
        }
    }

    protected void initProperties(Properties p) {
    }

    protected String getActionPath() {
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.resource = null;
        this.object = null;
        this.objects.clear();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() == 1) {
                Object o = structuredSelection.getFirstElement();
                this.process(o);
                if (this.object != null) {
                    action.setEnabled(this.compureEnabled());
                } else {
                    this.object = this.getObjectByResource(this.resource);
                    action.setEnabled(this.compureEnabled());
                }
            } else if (structuredSelection.size() > 1) {
                for (Object o : structuredSelection) {
                    this.object = null;
                    this.process(o);
                    if (this.object == null && this.resource != null) {
                        this.object = this.getObjectByResource(this.resource);
                    }
                    if (this.object != null) {
                        this.objects.add(this.object);
                        continue;
                    }
                    this.resource = null;
                    this.objects.clear();
                    action.setEnabled(this.compureEnabled());
                    return;
                }
                action.setEnabled(this.compureEnabled());
            }
        }
    }

    private void process(Object o) {
        if (!(this.checkModelObject(o) || this.checkFile(o) || this.checkProject(o))) {
            this.checkFolder(o);
        }
    }

    XModelObject getObjectByResource(IResource resource) {
        Object object = null;
        if (resource != null && !this.isRelevantProject(resource.getProject())) {
            resource = null;
        }
        if (resource == null) {
            object = null;
        } else if (resource instanceof IProject) {
            IModelNature n = EclipseResourceUtil.getModelNature((IProject)((IProject)resource));
            object = n != null ? FileSystemsHelper.getFileSystems((XModel)n.getModel()) : null;
        } else {
            object = EclipseResourceUtil.getObjectByResource((IResource)resource);
            if (object == null) {
                object = EclipseResourceUtil.createObjectForResource((IResource)resource);
            }
            if (object != null) {
                this.checkModelObject(object);
            }
        }
        return object;
    }

    protected boolean isRelevantProject(IProject project) {
        return true;
    }

    protected boolean checkModelObject(Object object) {
        if (object instanceof XModelObject) {
            this.object = (XModelObject)object;
            return true;
        }
        return false;
    }

    protected boolean checkFile(Object object) {
        if (object instanceof IFile) {
            if (this.isSupportingImplementation(IFile.class)) {
                this.resource = (IFile)object;
            } else if (this.isWindowAction && this.isSupportingImplementation(IProject.class)) {
                this.resource = ((IFile)object).getProject();
            }
        } else if (object instanceof IClassFile) {
            if (this.isSupportingImplementation(IFile.class)) {
                try {
                    this.resource = ((IClassFile)object).getCorrespondingResource();
                }
                catch (JavaModelException javaModelException) {}
            } else if (this.isWindowAction && this.isSupportingImplementation(IJavaProject.class)) {
                object = ((IClassFile)object).getJavaProject();
            }
        } else {
            return false;
        }
        return true;
    }

    protected boolean checkFolder(Object object) {
        if (object instanceof IFolder) {
            if (this.isSupportingImplementation(IFolder.class)) {
                this.resource = (IFolder)object;
            } else if (this.isWindowAction && this.isSupportingImplementation(IProject.class)) {
                this.resource = ((IResource)object).getProject();
            }
        } else {
            return false;
        }
        return true;
    }

    protected boolean checkProject(Object object) {
        IProject project = null;
        if (object instanceof IProject) {
            if (!this.isSupportingImplementation(IProject.class)) {
                return true;
            }
            project = (IProject)object;
        } else if (object instanceof IJavaProject) {
            if (!this.isSupportingImplementation(IJavaProject.class)) {
                return true;
            }
            project = ((IJavaProject)object).getProject();
        } else {
            return false;
        }
        if (!(project == null || project.isOpen() && this.hasModelNature(project))) {
            project = null;
        }
        this.resource = project;
        return true;
    }

    protected boolean hasModelNature(IProject project) {
        String[] s = EclipseResourceUtil.getModelNatureNames();
        int i = 0;
        while (i < s.length) {
            try {
                if (project.hasNature(s[i])) {
                    return true;
                }
            }
            catch (CoreException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
            ++i;
        }
        return false;
    }

    protected boolean isSupportingImplementation(Class cls) {
        return cls == IFile.class || cls == XModelObject.class;
    }

    protected boolean compureEnabled() {
        boolean enabled;
        boolean bl = enabled = this.object != null;
        if (enabled) {
            XAction a = this.object.getModelEntity().getActionList().getAction(this.getActionPath());
            enabled = a != null && (this.objects.size() < 2 ? a.isEnabled(this.object) : a.isEnabled(this.object, this.objects.toArray(new XModelObject[0])));
        }
        return enabled;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.isWindowAction = true;
    }
}

