/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.adapter;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.constraint.XProperty;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.attribute.IAttributeContentProposalProvider;
import org.jboss.tools.common.model.ui.attribute.adapter.PropertiesContentProposalProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesContentAssistProvider
implements IAttributeContentProposalProvider {
    XModelObject object;
    XEntityData data;
    XAttribute attribute;
    String fileName = null;
    String entity = null;
    static String EXTENSION_POINT = "org.jboss.tools.common.model.ui.propertiesFileContentAssist";
    static Set<String> entities = null;

    @Override
    public boolean isRelevant(XModelObject object, XAttribute attribute) {
        if (object == null || attribute == null) {
            return false;
        }
        if ("Property".equals(attribute.getModelEntity().getName())) {
            return true;
        }
        return PropertiesContentAssistProvider.getContributedEntities().contains(attribute.getModelEntity().getName());
    }

    @Override
    public void init(XModelObject object, XEntityData data, XAttribute attribute) {
        this.object = object;
        this.data = data;
        this.attribute = attribute;
        this.entity = attribute.getModelEntity().getName();
        this.fileName = null;
        XModelObject f = object;
        while (f != null && f.getFileType() != 1) {
            f = f.getParent();
        }
        if (f == null) {
            return;
        }
        this.fileName = FileAnyImpl.toFileName((XProperty)f);
    }

    @Override
    public IContentProposalProvider getContentProposalProvider() {
        if (this.fileName == null) {
            return null;
        }
        PropertiesContentProposalProvider provider = this.createProcessorByFileName(this.fileName, this.entity);
        return provider;
    }

    @Override
    public LabelProvider getCustomLabelProbider() {
        return null;
    }

    @Override
    public int getProposalAcceptanceStyle() {
        return 2;
    }

    @Override
    public void dispose() {
    }

    public static Set<String> getContributedEntities() {
        if (entities == null) {
            entities = new HashSet<String>();
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT);
            if (point != null) {
                IConfigurationElement[] cs;
                IConfigurationElement[] iConfigurationElementArray = cs = point.getConfigurationElements();
                int n = cs.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement c = iConfigurationElementArray[n2];
                    String entity = c.getAttribute("entity");
                    if (entity != null) {
                        entities.add(entity);
                    }
                    ++n2;
                }
            }
        }
        return entities;
    }

    private PropertiesContentProposalProvider createProcessorByFileName(String fileName, String entity) {
        IConfigurationElement[] cs;
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT);
        if (point == null) {
            return null;
        }
        IConfigurationElement[] iConfigurationElementArray = cs = point.getConfigurationElements();
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement c = iConfigurationElementArray[n2];
            if (fileName.equals(c.getAttribute("fileName")) || entity.equals(c.getAttribute("entity"))) {
                try {
                    PropertiesContentProposalProvider p = (PropertiesContentProposalProvider)c.createExecutableExtension("attributeProcessor");
                    p.object = this.object;
                    p.data = this.data;
                    p.attribute = this.attribute;
                    return p;
                }
                catch (CoreException e) {
                    ModelUIPlugin.getPluginLog().logError((Throwable)e);
                }
                catch (ClassCastException e2) {
                    ModelUIPlugin.getPluginLog().logError((Throwable)e2);
                }
            }
            ++n2;
        }
        return null;
    }
}

