/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.model.ui.IListEditor;
import org.jboss.tools.common.model.ui.IStructuredChangeListener;
import org.jboss.tools.common.model.ui.IStructuredEditor;
import org.jboss.tools.common.model.ui.IValueProvider;
import org.jboss.tools.common.model.ui.StructuredChange;
import org.jboss.tools.common.model.ui.StructuredChangedEvent;
import org.jboss.tools.common.model.ui.attribute.IListContentProvider;
import org.jboss.tools.common.model.ui.attribute.adapter.StructuredListAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyFieldEditor;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListStructuredFieldEditor
extends ExtendedFieldEditor
implements IPropertyFieldEditor,
IStructuredEditor,
IListEditor,
IFieldEditor,
PropertyChangeListener {
    protected IPropertyEditor propertyEditor;
    protected IValueProvider valueProvider;
    protected IStructuredChangeListener structuredChangeListener;
    protected StructuredListAdapter.INewValueProvider newStructuredElementProvider;
    protected ILabelProvider labelProvider;
    protected IListContentProvider listContentProvider;
    private org.eclipse.swt.widgets.List list;
    private Composite buttonBox;
    private static int ADD = 0;
    private static int REMOVE = 1;
    private static int UP = 2;
    private static int DOWN = 3;
    private Button[] buttons = new Button[4];
    private SelectionListener selectionListener;
    private Composite mainPanel;
    private List<Object> elements;

    public ListStructuredFieldEditor() {
    }

    public ListStructuredFieldEditor(IWidgetSettings settings) {
        super(settings);
    }

    private void doAdd() {
        this.setPresentsDefaultValue(false);
        Object[] input = this.getNewInputObjects();
        int i = 0;
        while (i < input.length) {
            String s = this.labelProvider.getText(input[i]);
            int index = this.list.getSelectionIndex();
            int target = -1;
            if (index >= 0) {
                this.elements.add(index + 1, input[i]);
                target = index + 1;
                this.list.add(s, target);
            } else {
                this.elements.add(i, input[i]);
                target = i;
                this.list.add(s, target);
            }
            this.selectionChanged(target);
            ++i;
        }
    }

    protected Object[] getNewInputObjects() {
        Object[] objectArray;
        Object value = this.newStructuredElementProvider.getValue();
        if (value == null) {
            objectArray = new Object[]{};
        } else if (value instanceof Object[]) {
            objectArray = (Object[])value;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = value;
        }
        Object[] values = objectArray;
        if (!this.allowDuplicates()) {
            HashSet<Object> set = new HashSet<Object>();
            ArrayList<Object> l = new ArrayList<Object>();
            set.addAll(this.elements);
            int i = 0;
            while (i < values.length) {
                if (!set.contains(values[i])) {
                    l.add(values[i]);
                    set.add(values[i]);
                }
                ++i;
            }
            values = l.toArray(new Object[0]);
        }
        return values;
    }

    @Override
    protected void adjustForNumColumns(int numColumns) {
        Control control = this.getLabelComposite();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.list.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    private void createButtons(Composite parent) {
        this.buttons[ListStructuredFieldEditor.ADD] = this.createButton(parent, "ListEditor.add");
        this.buttons[ListStructuredFieldEditor.REMOVE] = this.createButton(parent, "ListEditor.remove");
        this.buttons[ListStructuredFieldEditor.UP] = this.createButton(parent, "ListEditor.up");
        this.buttons[ListStructuredFieldEditor.DOWN] = this.createButton(parent, "ListEditor.down");
    }

    private Button createButton(Composite parent, String key) {
        Button b = new Button(parent, 8);
        b.setText(JFaceResources.getString((String)key));
        b.setFont(parent.getFont());
        GridData d = new GridData(768);
        d.heightHint = this.convertVerticalDLUsToPixels((Control)b, 14);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)b, 61);
        d.widthHint = Math.max(widthHint, b.computeSize((int)-1, (int)-1, (boolean)true).x);
        b.setLayoutData((Object)d);
        b.addSelectionListener(this.getSelectionListener());
        return b;
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.widget == ListStructuredFieldEditor.this.buttons[ADD]) {
                    ListStructuredFieldEditor.this.doAdd();
                } else if (event.widget == ListStructuredFieldEditor.this.buttons[REMOVE]) {
                    ListStructuredFieldEditor.this.doRemove();
                } else if (event.widget == ListStructuredFieldEditor.this.buttons[UP]) {
                    ListStructuredFieldEditor.this.doUp();
                } else if (event.widget == ListStructuredFieldEditor.this.buttons[DOWN]) {
                    ListStructuredFieldEditor.this.doDown();
                } else if (event.widget == ListStructuredFieldEditor.this.list) {
                    ListStructuredFieldEditor.this.selectionChanged(-1);
                }
            }
        };
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Control control = this.getLabelComposite(parent);
        this.assignLabelLayoutData(control, numColumns);
        this.list = this.createListControl(parent);
        this.assignListLayoutData((Control)this.list, numColumns);
        this.buttonBox = this.getButtonBoxControl(parent);
        this.assignButtonLayoutData((Control)this.buttonBox);
    }

    private void assignLabelLayoutData(Control control, int numColumns) {
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
    }

    private void assignListLayoutData(Control control, int numColumns) {
        GridData gd = new GridData(1808);
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
        control.setLayoutData((Object)gd);
    }

    private void assignButtonLayoutData(Control control) {
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        control.setLayoutData((Object)gd);
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
    }

    private void doDown() {
        this.swap(false);
    }

    protected Composite getButtonBoxControl(Composite parent) {
        if (this.buttonBox == null) {
            this.buttonBox = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.buttonBox.setLayout((Layout)layout);
            this.createButtons(this.buttonBox);
            this.buttonBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    int i = 0;
                    while (i < ListStructuredFieldEditor.this.buttons.length) {
                        ((ListStructuredFieldEditor)ListStructuredFieldEditor.this).buttons[i] = null;
                        ++i;
                    }
                    ListStructuredFieldEditor.this.buttonBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.buttonBox, parent);
        }
        this.selectionChanged(0);
        return this.buttonBox;
    }

    protected Composite getMainPanel(Composite parent) {
        if (this.mainPanel == null) {
            this.mainPanel = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            this.mainPanel.setLayout((Layout)layout);
            this.list = this.createListControl(this.mainPanel);
            GridData gd = new GridData(1808);
            gd.grabExcessHorizontalSpace = true;
            this.list.setLayoutData((Object)gd);
            this.buttonBox = this.getButtonBoxControl(this.mainPanel);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.buttonBox.setLayoutData((Object)gd);
            this.updateSelectionDependentActions();
        } else {
            this.checkParent((Control)this.mainPanel, parent);
        }
        return this.mainPanel;
    }

    protected org.eclipse.swt.widgets.List getListControl() {
        return this.list;
    }

    protected org.eclipse.swt.widgets.List createListControl(Composite parent) {
        if (this.list == null) {
            this.list = new org.eclipse.swt.widgets.List(parent, 2820);
            this.list.setFont(parent.getFont());
            this.list.addSelectionListener(this.getSelectionListener());
            this.list.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ListStructuredFieldEditor.this.list = null;
                }
            });
            this.list.setItems(this.getItems());
        } else if (this.mainPanel != null) {
            this.checkParent((Control)this.mainPanel, parent);
        } else {
            this.checkParent((Control)this.list, parent);
        }
        return this.list;
    }

    private List<Object> createElements() {
        ArrayList<Object> elements = new ArrayList<Object>();
        if (this.listContentProvider != null) {
            elements.addAll(Arrays.asList(this.listContentProvider.getElements(this)));
        }
        return elements;
    }

    private String[] getItems() {
        if (this.elements == null) {
            this.elements = this.createElements();
        }
        Iterator<Object> i = this.elements.iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (i.hasNext()) {
            Object o = i.next();
            String s = this.labelProvider.getText(o);
            list.add(s);
        }
        return list.toArray(new String[list.size()]);
    }

    public int getNumberOfControls() {
        return 2;
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    protected Shell getShell() {
        if (this.buttons[ADD] == null) {
            return null;
        }
        return this.buttons[ADD].getShell();
    }

    private void doRemove() {
        this.setPresentsDefaultValue(false);
        int index = this.list.getSelectionIndex();
        if (index >= 0) {
            this.list.remove(index);
            this.elements.remove(index);
            index = this.list.getItemCount() <= index ? this.list.getItemCount() - 1 : index;
            this.selectionChanged(index);
        }
    }

    private void selectionChanged(int newSelection) {
        StructuredChange change = new StructuredChange(this.elements);
        StructuredChangedEvent event = new StructuredChangedEvent(this.listContentProvider, change);
        this.structuredChangeListener.structureChanged(event);
        if (newSelection >= 0 && newSelection < this.list.getItemCount()) {
            this.list.select(newSelection);
        }
        this.updateSelectionDependentActions();
    }

    private void updateSelectionDependentActions() {
        int index = this.list.getSelectionIndex();
        int size = this.list.getItemCount();
        this.buttons[REMOVE].setEnabled(index >= 0);
        this.buttons[UP].setEnabled(size > 1 && index > 0);
        this.buttons[DOWN].setEnabled(size > 1 && index >= 0 && index < size - 1);
    }

    public void setFocus() {
        if (this.list != null) {
            this.list.setFocus();
        }
    }

    private void swap(boolean up) {
        int target;
        this.setPresentsDefaultValue(false);
        int index = this.list.getSelectionIndex();
        int n = target = up ? index - 1 : index + 1;
        if (index >= 0) {
            String[] selection = this.list.getSelection();
            Assert.isTrue((selection.length == 1 ? 1 : 0) != 0);
            this.list.remove(index);
            this.list.add(selection[0], target);
            this.list.setSelection(target);
            Object o = this.elements.get(index);
            this.elements.remove(index);
            this.elements.add(target, o);
        }
        this.selectionChanged(target);
    }

    private void doUp() {
        this.swap(true);
    }

    @Override
    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.createListControl(parent).setEnabled(enabled);
        this.buttons[ADD].setEnabled(enabled);
        if (!enabled) {
            this.buttons[REMOVE].setEnabled(enabled);
            this.buttons[UP].setEnabled(enabled);
            this.buttons[DOWN].setEnabled(enabled);
        } else {
            this.updateSelectionDependentActions();
        }
    }

    public void setStructuredChangeListener(IStructuredChangeListener structuredChangeListener) {
        this.structuredChangeListener = structuredChangeListener;
    }

    @Override
    public void setStructuredContentProvider(IStructuredContentProvider structuredContentProvider) {
    }

    public void setNewStructuredElementProvider(StructuredListAdapter.INewValueProvider valueProvider) {
        this.newStructuredElementProvider = valueProvider;
    }

    @Override
    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    @Override
    public void setListContentProvider(IListContentProvider listContentProvider) {
        this.listContentProvider = listContentProvider;
    }

    @Override
    public Control[] getControls(Composite parent) {
        return new Control[]{this.getLabelComposite(parent), this.getMainPanel(parent)};
    }

    @Override
    public void setPropertyEditor(IPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        if (propertyEditor != null) {
            this.valueProvider = (IValueProvider)propertyEditor.getAdapter(IValueProvider.class);
            this.structuredChangeListener = (IStructuredChangeListener)propertyEditor.getAdapter(IStructuredChangeListener.class);
            this.listContentProvider = (IListContentProvider)propertyEditor.getAdapter(IListContentProvider.class);
            this.newStructuredElementProvider = (StructuredListAdapter.INewValueProvider)propertyEditor.getAdapter(StructuredListAdapter.INewValueProvider.class);
            this.labelProvider = (ILabelProvider)propertyEditor.getAdapter(ILabelProvider.class);
        }
        this.valueProvider.addValueChangeListener(this);
    }

    protected boolean allowDuplicates() {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        this.valueProvider.removeValueChangeListener(this);
        if ("IPropertyEditor.value".equals(evt.getPropertyName())) {
            this.elements = null;
            if (this.list != null) {
                this.list.setItems(this.getItems());
                this.list.redraw();
            }
        }
        this.valueProvider.addValueChangeListener(this);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.getListControl() != null) {
            this.getListControl().setEnabled(enabled);
        }
    }

    @Override
    public void cut() {
    }

    @Override
    public void copy() {
    }

    @Override
    public void paste() {
    }

    @Override
    public void delete() {
    }
}

