/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.model.ui.attribute.editor.StringFieldEditor;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;

public abstract class StringButtonFieldEditor
extends StringFieldEditor {
    private Button button;
    private String buttonName;

    public StringButtonFieldEditor() {
    }

    public StringButtonFieldEditor(IWidgetSettings settings) {
        super(settings);
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.getTextControl().getLayoutData()).horizontalSpan = numColumns - 2;
    }

    protected abstract String changePressed();

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns - 1);
        this.button = this.getChangeControl(parent);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.heightHint = this.convertVerticalDLUsToPixels((Control)this.button, 14);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)this.button, 61);
        gd.widthHint = Math.max(widthHint, this.button.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.button.setLayoutData((Object)gd);
    }

    protected Button getChangeControl(Composite parent) {
        if (this.button != null) {
            this.checkParent((Control)this.button, parent);
            return this.button;
        }
        int style = this.getSettings().getStyle("Button.Style");
        if (style == -1) {
            style = 0;
        }
        if (style == 0) {
            style = 8;
        }
        Color fg = this.getSettings().getColor("Button.Foreground");
        Font font = this.getSettings().getFont("Button.Font");
        this.button = new Button(parent, style);
        this.button.setFont(font);
        this.button.setForeground(fg);
        if (this.buttonName == null) {
            this.buttonName = JFaceResources.getString((String)"openChange");
        }
        this.button.setText(this.buttonName);
        this.button.setFont(parent.getFont());
        this.addListeners();
        return this.button;
    }

    void addListeners() {
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String oldValue = StringButtonFieldEditor.this.getStringValue();
                String newValue = StringButtonFieldEditor.this.changePressed();
                if (newValue != null) {
                    StringButtonFieldEditor.this.setStringValue(oldValue);
                    StringButtonFieldEditor.this.setStringValue(newValue);
                }
            }
        });
        this.button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                StringButtonFieldEditor.this.button = null;
            }
        });
    }

    public int getNumberOfControls() {
        return 3;
    }

    protected Shell getShell() {
        if (this.button == null) {
            return null;
        }
        return this.button.getShell();
    }

    public void setChangeButtonText(String text) {
        Assert.isNotNull((Object)text);
        this.buttonName = text;
        if (this.button != null) {
            this.button.setText(text);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.getTextControl() != null) {
            boolean b = this.isAlwaysReadOnly();
            this.getTextControl().setEnabled(enabled || b);
        }
        if (this.button != null) {
            this.button.setEnabled(enabled);
        }
    }

    protected Button getChangeControl() {
        return this.button;
    }
}

