/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.common.model.ui.attribute.IPropertyDescriptorEx;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;

public class TreeFieldEditor
extends ExtendedFieldEditor {
    protected IPropertyDescriptorEx description;
    private TreeViewer tree = null;
    private Text text;
    private String stringValue;
    private Composite treeAndText;

    public TreeFieldEditor() {
    }

    public TreeFieldEditor(IWidgetSettings settings) {
        super(settings);
    }

    public TreeFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        Control control = this.getLabelComposite();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.treeAndText.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Control control = this.getLabelComposite(parent);
        GridData gd = new GridData();
        gd.verticalAlignment = 1024;
        control.setLayoutData((Object)gd);
        this.treeAndText = this.getTreeAndTextControl(parent);
        gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
        this.treeAndText.setLayoutData((Object)gd);
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected Control getTreeControl() {
        if (this.tree != null) {
            return this.tree.getControl();
        }
        return null;
    }

    protected Control getTextControl() {
        return this.text;
    }

    protected Control createTreeControl(Composite parent) {
        if (this.tree == null) {
            this.tree = new TreeViewer(parent, 2048);
        }
        return this.tree.getControl();
    }

    protected Control createTextControl(Composite parent) {
        if (this.text == null) {
            this.text = new Text(parent, 2052);
        }
        return this.text;
    }

    protected Composite getTreeAndTextControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Control control = this.createTreeControl(composite);
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        control = this.createTextControl(composite);
        gd = new GridData(768);
        control.setLayoutData((Object)gd);
        return composite;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String string) {
        this.stringValue = string;
    }

    public IPropertyDescriptorEx getDescription() {
        return this.description;
    }

    public void setDescription(IPropertyDescriptorEx description) {
        this.description = description;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.getTreeControl() != null) {
            this.getTreeControl().setEnabled(enabled);
        }
        if (this.getTextControl() != null) {
            this.getTextControl().setEnabled(enabled);
        }
    }

    public void cut() {
    }

    public void copy() {
    }

    public void paste() {
    }

    public void delete() {
    }
}

