/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.editor;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.jboss.tools.common.model.ui.ModelUIPlugin;

public class EditorPartFactory {
    IConfigurationElement element;
    String id;
    Class editorClass;
    Class contributorClass;

    EditorPartFactory(IConfigurationElement element, Class editorClass, Class contributorClass) throws InstantiationException, IllegalAccessException {
        this.element = element;
        this.editorClass = editorClass;
        this.contributorClass = contributorClass;
        if (!IEditorPart.class.isAssignableFrom(editorClass)) {
            throw new ClassCastException("Class " + editorClass + " must be instance of org.eclipse.ui.IEditorPart");
        }
        if (!IEditorActionBarContributor.class.isAssignableFrom(contributorClass)) {
            throw new ClassCastException("Class " + contributorClass.getName() + " must be instance of org.eclipse.ui.IEditorActionBarContributor");
        }
        editorClass.newInstance();
        contributorClass.newInstance();
        this.id = editorClass.getName();
    }

    public IEditorPart createEditorPart() {
        IEditorPart part = null;
        try {
            part = (IEditorPart)this.editorClass.newInstance();
        }
        catch (InstantiationException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (IllegalAccessException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        return part;
    }

    public IEditorActionBarContributor createEditorActionBarContributor() {
        IEditorActionBarContributor contributor = null;
        try {
            contributor = (IEditorActionBarContributor)this.contributorClass.newInstance();
        }
        catch (InstantiationException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (IllegalAccessException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        return contributor;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.element;
    }

    public String getEditorId() {
        return this.id;
    }
}

