/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.editor;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.editor.EditorPartFactory;
import org.osgi.framework.Bundle;

public class EditorPartWrapperExtension {
    static String POINT_ID = "org.jboss.tools.common.model.ui.xmlEditor";
    static EditorPartWrapperExtension instance;
    Map<String, EditorPartFactory> factories = new HashMap<String, EditorPartFactory>();
    Map<String, Integer> priorities = new HashMap<String, Integer>();
    IExtensionPoint point = null;

    public static EditorPartWrapperExtension getInstance() {
        if (instance == null) {
            instance = new EditorPartWrapperExtension();
            instance.init();
        }
        return instance;
    }

    private EditorPartWrapperExtension() {
    }

    private void init() {
        this.point = Platform.getExtensionRegistry().getExtensionPoint(POINT_ID);
        IExtension[] es = this.point.getExtensions();
        int i = 0;
        while (i < es.length) {
            IConfigurationElement[] cs = es[i].getConfigurationElements();
            int j = 0;
            while (j < cs.length) {
                block14: {
                    Bundle bundle = Platform.getBundle((String)es[i].getNamespaceIdentifier());
                    String entities = cs[j].getAttribute("entities");
                    String editor = cs[j].getAttribute("class");
                    String priorityString = cs[j].getAttribute("priority");
                    int priority = 0;
                    try {
                        if (priorityString != null && priorityString.length() > 0) {
                            priority = Integer.parseInt(priorityString);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        ModelUIPlugin.getPluginLog().logError("Incorrect priority value " + priorityString + ".");
                    }
                    Class editorClass = null;
                    try {
                        editorClass = bundle.loadClass(editor);
                    }
                    catch (ClassNotFoundException e) {
                        if (!ModelUIPlugin.getDefault().isDebugging()) break block14;
                        ModelUIPlugin.getPluginLog().logError("Cannot load editor class " + editor + " from " + es[i].getNamespaceIdentifier(), (Throwable)e);
                        break block14;
                    }
                    String contributor = cs[j].getAttribute("contributorClass");
                    Class<EditorActionBarContributor> contributorClass = null;
                    try {
                        contributorClass = bundle.loadClass(contributor);
                    }
                    catch (ClassNotFoundException e) {
                        if (ModelUIPlugin.getDefault().isDebugging()) {
                            String message = "Cannot load contributor class " + contributor;
                            ModelUIPlugin.getPluginLog().logError(message, (Throwable)e);
                        }
                        contributorClass = EditorActionBarContributor.class;
                    }
                    EditorPartFactory f = null;
                    try {
                        f = new EditorPartFactory(cs[j], editorClass, contributorClass);
                    }
                    catch (InstantiationException e) {
                        ModelUIPlugin.getPluginLog().logError((Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        ModelUIPlugin.getPluginLog().logError((Throwable)e);
                    }
                    StringTokenizer st = new StringTokenizer(entities, ",;");
                    while (st.hasMoreTokens()) {
                        int tp;
                        String t = st.nextToken();
                        Integer p = this.priorities.get(t);
                        int n = tp = p == null ? Integer.MAX_VALUE : p;
                        if (priority >= tp) continue;
                        this.factories.put(t, f);
                        this.priorities.put(t, priority);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public EditorPartFactory getFactory(String entity) {
        return this.factories.get(entity);
    }
}

