/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.editors.dnd;

import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.jboss.tools.common.model.XModelBuffer;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.dnd.DnDUtil;
import org.jboss.tools.common.model.ui.editors.dnd.DefaultDropWizardModel;
import org.jboss.tools.common.model.ui.editors.dnd.DropUtils;
import org.jboss.tools.common.model.ui.editors.dnd.IAttributeValueLoader;
import org.jboss.tools.common.model.ui.editors.dnd.IDropWizardModel;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public class AbsoluteFilePathAttributeValueLoader
implements IAttributeValueLoader {
    String fPathAttributeName;
    String fWidthAttributeName;
    String fHeightAttributeName;

    public AbsoluteFilePathAttributeValueLoader(String pathAttributeName, String widthAttributeName, String heightAttributeName) {
        this.fPathAttributeName = pathAttributeName;
        this.fWidthAttributeName = widthAttributeName;
        this.fHeightAttributeName = heightAttributeName;
    }

    public void fillTagAttributes(IDropWizardModel model) {
        IFile file = DropUtils.getResourceForMimeData(model.getDropData());
        if (file == null) {
            return;
        }
        IProject project = null;
        IEditorInput editorInput = model.getDropData().getEditorInput();
        IFileEditorInput input = null;
        if (editorInput instanceof IFileEditorInput) {
            input = (IFileEditorInput)editorInput;
            project = input.getFile().getProject();
        } else {
            project = file.getProject();
        }
        IContainer container = DropUtils.getWebRootContainer(project);
        if (file != null) {
            String v;
            IPath filePath = file.getProjectRelativePath();
            IPath containerPath = container.getProjectRelativePath();
            filePath = filePath.removeFirstSegments(containerPath.matchingFirstSegments(filePath));
            String string = v = input == null ? null : this.dropFileToFile(file, input.getFile(), model);
            if (v == null) {
                v = "/" + filePath.toString();
            }
            model.setAttributeValue(this.fPathAttributeName, (Object)v);
            if (model instanceof DefaultDropWizardModel) {
                ((DefaultDropWizardModel)model).setPreferable(this.fPathAttributeName);
            }
        }
    }

    private String dropFileToFile(IFile source, IFile target, IDropWizardModel model) {
        XModelObject t = EclipseResourceUtil.getObjectByResource((IResource)target);
        XModelObject s = EclipseResourceUtil.getObjectByResource((IResource)source);
        if (t == null || s == null) {
            return null;
        }
        XModelBuffer b = s.getModel().getModelBuffer();
        XModelObject c = b.source();
        b.clear();
        b.addSource(s);
        try {
            if (!DnDUtil.isPasteEnabled(t)) {
                return null;
            }
            Properties p = new Properties();
            String tagName = model.getTagProposal().getName();
            p.setProperty("isDrop", "true");
            if (tagName != null) {
                p.setProperty("context:tagName", tagName);
            }
            DnDUtil.paste(t, p);
            String string = p.getProperty("start text");
            return string;
        }
        catch (XModelException xModelException) {
            return null;
        }
        finally {
            b.clear();
            if (c != null) {
                b.addSource(c);
            }
        }
    }
}

