/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.editors.dnd.composite;

import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.jboss.tools.common.model.ui.editors.dnd.DropData;
import org.jboss.tools.common.model.ui.editors.dnd.IDropWizardModel;
import org.jboss.tools.common.model.ui.editors.dnd.ITagProposal;
import org.jboss.tools.common.model.ui.editors.dnd.ITagProposalFactory;

public class TagProposalsComposite
extends Composite {
    private ITagProposal selection = IDropWizardModel.UNDEFINED_TAG_PROPOSAL;
    CheckboxTableViewer tableTreeViewer;
    ITagProposal[] fTagProposals;
    IDropWizardModel fModel;

    public TagProposalsComposite(Composite parent, int styles, IDropWizardModel model) {
        super(parent, styles);
        this.fModel = model;
        this.fTagProposals = model.getTagProposalFactory().getProposalLoader(this.fModel.getDropData().getMimeType()).getTagProposals(this.fModel.getDropData());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        this.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        this.setLayoutData(data);
        Table swtTable = new Table((Composite)this, 68388);
        data = new GridData(1808);
        TableLayout tableLayout = new TableLayout();
        this.tableTreeViewer = new CheckboxTableViewer(swtTable);
        swtTable.setLayout((Layout)tableLayout);
        swtTable.setLayoutData((Object)data);
        swtTable.setHeaderVisible(true);
        swtTable.setLinesVisible(true);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(150));
        TableColumn col = new TableColumn(swtTable, 0);
        col.setText("Tag name");
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(250));
        col = new TableColumn(swtTable, 0);
        col.setText("URI");
        this.tableTreeViewer.setColumnProperties(new String[]{"Tag Name", "URI"});
        this.tableTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ITagProposal proposal = (ITagProposal)event.getElement();
                if (event.getChecked()) {
                    if (TagProposalsComposite.this.selection != IDropWizardModel.UNDEFINED_TAG_PROPOSAL) {
                        TagProposalsComposite.this.tableTreeViewer.setChecked((Object)TagProposalsComposite.this.selection, false);
                    }
                    TagProposalsComposite.this.selection = proposal;
                } else {
                    TagProposalsComposite.this.selection = IDropWizardModel.UNDEFINED_TAG_PROPOSAL;
                }
                TagProposalsComposite.this.fModel.setTagProposal(TagProposalsComposite.this.selection);
            }
        });
        this.tableTreeViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return TagProposalsComposite.this.fTagProposals;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tableTreeViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){
            public static final int TAG_NAME_INDEX = 0;
            public static final int TAG_URI_INDEX = 1;

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                ITagProposal prop = (ITagProposal)element;
                switch (columnIndex) {
                    case 0: {
                        return prop.getDisplayString();
                    }
                    case 1: {
                        return prop.getDetails();
                    }
                }
                throw new IllegalArgumentException("Wrong column index for LabelProvider");
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.tableTreeViewer.setInput((Object)"ROOT");
    }

    public ITagProposal[] getTagProposals() {
        return this.fTagProposals;
    }

    public boolean hasTagProposals() {
        return this.getTagProposals().length > 0;
    }

    public static boolean areThereTagProposals(String mimeType, DropData dropData, ITagProposalFactory tagProposalFactory) {
        return tagProposalFactory.getProposalLoader(mimeType).getTagProposals(dropData).length > 0;
    }

    public static ITagProposal[] getTagProposals(String mimeType, DropData dropData, ITagProposalFactory tagProposalFactory) {
        return tagProposalFactory.getProposalLoader(mimeType).getTagProposals(dropData);
    }
}

