/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.forms;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.jboss.tools.common.model.ui.forms.DefaultForm;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;

public class ExpandableForm
extends DefaultForm {
    public static final int SELECTION = 1;
    private Control client;
    private String description;
    protected Label descriptionLabel;
    private boolean descriptionPainted = true;
    private boolean collapsable = true;
    private boolean collapsed = false;
    private Composite control;
    private static final String COLLAPSED_ID = "collapsed";
    protected Section section;
    private Layout layout;

    public void dispose() {
        super.dispose();
        if (this.descriptionLabel != null && this.descriptionLabel.isDisposed()) {
            this.descriptionLabel.dispose();
        }
        this.descriptionLabel = null;
        if (this.client != null && !this.client.isDisposed()) {
            this.client.dispose();
        }
        this.client = null;
        if (this.control != null && !this.control.isDisposed()) {
            this.control.dispose();
        }
        this.control = null;
        if (this.section != null) {
            if (!this.section.isDisposed()) {
                this.section.dispose();
            }
            this.section = null;
        }
    }

    public Control getControl() {
        return this.control;
    }

    public Control createControl(Composite parent, IWidgetSettings settings) {
        FormToolkit toolkit = settings.getToolkit(parent.getDisplay());
        if (toolkit == null) {
            toolkit = new FormToolkit(parent.getDisplay());
        }
        this.section = toolkit.createSection(parent, 578);
        this.section.setText(this.getHeadingText());
        this.section.setLayoutData((Object)new GridData(770));
        toolkit.adapt((Composite)this.section);
        this.section.setBackground(parent.getBackground());
        Section composite = this.section;
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData(this.getLayoutData());
        composite.setData((Object)this);
        if (this.collapsable) {
            this.section.addExpansionListener(new IExpansionListener(){

                public void expansionStateChanged(ExpansionEvent e) {
                    ExpandableForm.this.collapsed = !ExpandableForm.this.section.isExpanded();
                }

                public void expansionStateChanging(ExpansionEvent e) {
                }
            });
        }
        if (this.descriptionPainted && this.description != null) {
            this.descriptionLabel = new Label((Composite)composite, 64);
            settings.setupControl((Control)this.descriptionLabel);
        }
        this.client = this.createClientArea((Composite)composite, settings);
        composite.setData((Object)this);
        this.control = composite;
        if (this.isCollapsed()) {
            this.section.setExpanded(false);
        }
        this.section.setClient(this.client);
        return this.control;
    }

    protected void reflow() {
        if (this.control == null) {
            return;
        }
        Composite parent = this.control.getParent();
        Composite parentParent = null;
        if (parent != null) {
            parentParent = parent.getParent();
        }
        this.control.setRedraw(false);
        if (parent != null) {
            this.control.getParent().setRedraw(false);
        }
        if (parentParent != null) {
            this.control.getParent().getParent().setRedraw(false);
        }
        this.control.layout(true);
        if (parent != null) {
            this.control.getParent().layout(true);
        }
        if (parentParent != null) {
            this.control.getParent().getParent().layout(true);
        }
        this.control.setRedraw(true);
        if (parent != null) {
            this.control.getParent().setRedraw(true);
        }
        if (parentParent != null) {
            this.control.getParent().getParent().setRedraw(true);
        }
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public boolean isCollapsable() {
        return this.collapsable;
    }

    public void setCollapsable(boolean b) {
        this.collapsable = b;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean b) {
        this.collapsed = b;
    }

    public void load(IMemento memento) {
        String collapsed = memento.getString(COLLAPSED_ID);
        if (collapsed != null) {
            this.setCollapsed(Boolean.valueOf(collapsed));
        }
    }

    public void store(IMemento memento) {
        memento.putString(COLLAPSED_ID, "" + this.isCollapsed());
    }
}

