/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.navigator;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.jboss.tools.common.model.XFilteredTree;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.ModelUIPlugin;

public class FilteredTreeContentProvider
implements ITreeContentProvider {
    protected String filteredTreeName;
    protected XFilteredTree filteredTree;
    private XModel model;

    public void setViewer(TreeViewer viewer) {
    }

    public void setModel(XModel model) {
        this.model = model;
    }

    public void setFilteredTreeName(String filteredTreeName) {
        this.filteredTreeName = filteredTreeName;
    }

    protected XFilteredTree createFilteredTree() {
        XFilteredTree result = this.getFilteredTree();
        if (!(result == null || result.getRoot() != null && result.getRoot().isActive())) {
            result = null;
        }
        if (result == null) {
            try {
                String classname = this.model.getMetaData().getMapping("FilteredTrees").getValue(this.filteredTreeName);
                result = (XFilteredTree)this.getClass().getClassLoader().loadClass(classname).newInstance();
                result.setModel(this.model);
            }
            catch (InstantiationException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
            catch (IllegalAccessException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        return result;
    }

    protected XFilteredTree getFilteredTree() {
        return this.filteredTree;
    }

    public Object[] getChildren(Object parentElement) {
        return this.getFilteredTree().getChildren((XModelObject)parentElement);
    }

    public Object getParent(Object element) {
        return this.getFilteredTree().getParent((XModelObject)element);
    }

    public boolean hasChildren(Object element) {
        return this.getFilteredTree().hasChildren((XModelObject)element);
    }

    public Object[] getElements(Object inputElement) {
        Object[] objectArray;
        this.filteredTree = this.createFilteredTree();
        if (this.filteredTree == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.filteredTree.getRoot();
        }
        return objectArray;
    }

    public void dispose() {
        this.filteredTree = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

