/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.templates.model;

import org.jboss.tools.common.model.ui.templates.model.MetaElementFactory;
import org.jboss.tools.common.model.ui.templates.model.MetaValue;
import org.jboss.tools.common.model.ui.templates.model.MetaValueList;

public class MetaClassTemplate {
    private MetaClassTemplate parent;
    private String axis;
    private String displayName;
    private String xEntity;
    private MetaValue superClass;
    private MetaValueList interfaces;

    public void setParent(MetaClassTemplate parent) {
        this.parent = parent;
        if (parent == null) {
            this.superClass = MetaElementFactory.instance.createValue(null);
            this.interfaces = MetaElementFactory.instance.createValueList(null);
        } else {
            this.axis = parent.getAxis();
            this.displayName = parent.getDisplayName();
            this.xEntity = parent.getXEntity();
            this.superClass = MetaElementFactory.instance.createValue(parent.getSuperClass());
            this.interfaces = MetaElementFactory.instance.createValueList(parent.getInterfaces());
        }
    }

    public MetaValue getSuperClass() {
        return this.superClass;
    }

    public MetaValueList getInterfaces() {
        return this.interfaces;
    }

    public String getAxis() {
        return this.axis;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getXEntity() {
        return this.xEntity;
    }

    public void setAxis(String axis) {
        this.axis = axis;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setXEntity(String entity) {
        this.xEntity = entity;
    }

    public boolean isOverriding() {
        return this.superClass.isOverriding() && !this.isOverridingDefaultClass() || this.interfaces.isOverriding();
    }

    private boolean isOverridingDefaultClass() {
        String pv;
        if (!"java.lang.Object".equals(this.superClass.getValue())) {
            return false;
        }
        String string = pv = this.parent == null ? null : this.parent.getSuperClass().getValue();
        return pv == null || pv.length() == 0;
    }

    public void commitToParent() {
        if (this.parent == null) {
            return;
        }
        this.superClass.commitToParent();
        this.interfaces.commitToParent();
    }

    public void loadFromParent(int depth) {
        if (this.parent == null) {
            return;
        }
        this.superClass.loadFromParent(depth);
        this.interfaces.loadFromParent(depth);
    }
}

