/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.views.navigator;

import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.dnd.DnDUtil;

public class NSelectionAction
extends BaseSelectionListenerAction {
    private boolean selectionDirty = true;
    XModelObject target;
    XModelObject[] targets;

    protected NSelectionAction(String text) {
        super(text);
    }

    protected void clearCache() {
        this.selectionDirty = true;
        this.target = null;
        this.targets = null;
    }

    private final void computeResources() {
        if (!this.selectionDirty) {
            return;
        }
        this.selectionDirty = false;
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        Object o2 = selection.getFirstElement();
        if (!(o2 instanceof XModelObject)) {
            return;
        }
        this.target = (XModelObject)o2;
        ArrayList<XModelObject> list = new ArrayList<XModelObject>();
        for (Object o2 : selection) {
            if (!(o2 instanceof XModelObject)) continue;
            list.add((XModelObject)o2);
        }
        if (list.size() > 1) {
            this.targets = list.toArray(new XModelObject[0]);
        }
    }

    protected final boolean updateSelection(IStructuredSelection selection) {
        this.computeResources();
        return this.updateSelection(this.target, this.targets);
    }

    protected boolean updateSelection(XModelObject target, XModelObject[] targets) {
        return this.isXActionEnabled();
    }

    private boolean isXActionEnabled() {
        return DnDUtil.getEnabledAction(this.target, this.targets, this.getActionPath()) != null;
    }

    protected String getActionPath() {
        return null;
    }

    public void run() {
        if (!this.isXActionEnabled()) {
            return;
        }
        XActionInvoker.invoke((String)this.getActionPath(), (XModelObject)this.target, (XModelObject[])this.targets, (Properties)new Properties());
    }
}

