/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.views.palette;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.editor.EditorDescriptor;

public class PaletteContents {
    private String[] natureTypes;
    private String[] editorTypes;

    public PaletteContents(IEditorPart editorPart) {
        if (editorPart == null) {
            this.emptyInit();
            return;
        }
        EditorDescriptor editorDescriptor = (EditorDescriptor)editorPart.getAdapter(EditorDescriptor.class);
        this.editorTypes = editorDescriptor != null ? editorDescriptor.getEditorTypes() : new String[0];
        IEditorInput input = editorPart.getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            this.natureTypes = new String[0];
            return;
        }
        IFile file = ((IFileEditorInput)input).getFile();
        if (file == null) {
            this.natureTypes = new String[0];
            return;
        }
        IProject project = file.getProject();
        ArrayList<String> natures = new ArrayList<String>();
        try {
            if (project.exists() && project.isOpen() && project.hasNature("org.jboss.tools.struts.strutsnature")) {
                natures.add("struts");
            }
        }
        catch (CoreException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        try {
            if (project.exists() && project.isOpen() && project.hasNature("org.jboss.tools.jsf.jsfnature")) {
                natures.add("jsf");
            }
        }
        catch (CoreException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        this.natureTypes = natures.size() > 0 ? natures.toArray(new String[natures.size()]) : new String[0];
    }

    private void emptyInit() {
        this.natureTypes = new String[0];
        this.editorTypes = new String[0];
    }

    public boolean equalsContents(PaletteContents contents) {
        if (contents == null || contents.empty()) {
            return this.empty();
        }
        if (this.empty()) {
            return false;
        }
        if (!this.coincide(this.natureTypes, contents.getNatureTypes())) {
            return false;
        }
        return this.coincide(this.editorTypes, contents.getEditorTypes());
    }

    public boolean contains(String[] natures, String[] editors) {
        return this.intersection(this.natureTypes, natures) && this.intersection(this.editorTypes, editors);
    }

    private boolean intersection(String[] environmentTypes, String[] paletteTypes) {
        if (paletteTypes == null || paletteTypes.length <= 0) {
            return true;
        }
        int i = 0;
        while (i < environmentTypes.length) {
            int j = 0;
            while (j < paletteTypes.length) {
                if (environmentTypes[i].equalsIgnoreCase(paletteTypes[j])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private boolean coincide(String[] types1, String[] types2) {
        if (types1.length != types2.length) {
            return false;
        }
        int i = 0;
        while (i < types1.length) {
            boolean found = false;
            int j = 0;
            while (j < types2.length) {
                if (types1[i].equalsIgnoreCase(types2[j])) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean empty() {
        return this.natureTypes.length <= 0 && this.editorTypes.length <= 0;
    }

    public String[] getNatureTypes() {
        return this.natureTypes;
    }

    public String[] getEditorTypes() {
        return this.editorTypes;
    }
}

