/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.jboss.tools.common.model.ui.widgets.Viewport;

public class ScrolledComposite
extends Composite {
    private Composite viewport;
    private boolean fixedWidth;
    private boolean fixedHeight;
    private boolean inResize;
    private boolean grabHSpace = Boolean.TRUE;
    private boolean grabVSpace = Boolean.TRUE;
    private int lock = 0;

    public ScrolledComposite(Composite parent, int style) {
        super(parent, ScrolledComposite.checkStyle(style));
        this.setBackground(parent.getBackground());
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar != null) {
            hBar.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    ScrolledComposite.this.hScroll();
                }
            });
        } else {
            this.fixedWidth = Boolean.TRUE;
        }
        ScrollBar vBar = this.getVerticalBar();
        vBar.setIncrement(10);
        if (vBar != null) {
            vBar.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    ScrolledComposite.this.vScroll();
                }
            });
        } else {
            this.fixedHeight = Boolean.TRUE;
        }
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                ScrolledComposite.this.resize();
            }
        });
        Label label = new Label((Composite)this, 0);
        label.setText("Test");
        this.viewport = new Viewport(this, 0);
    }

    private static int checkStyle(int style) {
        int mask = 0x6000B00;
        return style & mask;
    }

    private void vScroll() {
        if (this.viewport == null) {
            return;
        }
        Point location = this.viewport.getLocation();
        ScrollBar vBar = this.getVerticalBar();
        int vSelection = vBar.getSelection();
        this.viewport.setLocation(location.x, -vSelection);
    }

    private void hScroll() {
        if (this.viewport == null) {
            return;
        }
        Point location = this.viewport.getLocation();
        ScrollBar hBar = this.getHorizontalBar();
        int hSelection = hBar.getSelection();
        this.viewport.setLocation(-hSelection, location.y);
    }

    private void resize() {
        if (this.inResize) {
            return;
        }
        this.inResize = Boolean.TRUE;
        this.layout();
        this.inResize = Boolean.FALSE;
    }

    public Composite getViewport() {
        return this.viewport;
    }

    public void setLayout(Layout layout) {
        if (this.viewport != null) {
            this.viewport.setLayout(layout);
        }
    }

    public void layout(boolean changed) {
        this.checkWidget();
        if (this.viewport == null) {
            return;
        }
        if (this.lock > 0) {
            return;
        }
        ++this.lock;
        try {
            this.doLayout();
        }
        finally {
            --this.lock;
        }
    }

    private void doLayout() {
        Point viewportSize = this.viewport.computeSize(-1, -1, Boolean.TRUE.booleanValue());
        Point viewportLocation = this.viewport.getLocation();
        Rectangle cr = new Rectangle(viewportLocation.x, viewportLocation.y, viewportSize.x, viewportSize.y);
        Rectangle hr = this.getClientArea();
        if (this.fixedWidth) {
            cr.width = hr.width;
        } else if (this.grabHSpace) {
            cr.width = Math.max(cr.width, hr.width);
        }
        if (this.fixedHeight) {
            cr.height = hr.height;
        } else if (this.grabVSpace) {
            cr.height = Math.max(cr.height, hr.height);
        }
        this.layoutHBar(cr, hr);
        this.layoutVBar(cr, hr);
        this.viewport.setBounds(cr);
    }

    private void layoutHBar(Rectangle cr, Rectangle hr) {
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar == null) {
            return;
        }
        hBar.setMaximum(cr.width);
        hBar.setThumb(Math.min(cr.width, hr.width));
        int hs = hBar.getSelection();
        if (hs >= cr.width - hr.width) {
            if (cr.width <= hr.width) {
                hs = 0;
                hBar.setSelection(0);
            }
            cr.x = -hs;
        }
        if (hBar.getThumb() >= hBar.getMaximum()) {
            hBar.setVisible(false);
        } else {
            hBar.setVisible(true);
        }
    }

    private void layoutVBar(Rectangle cr, Rectangle hr) {
        ScrollBar vBar = this.getVerticalBar();
        if (vBar == null) {
            return;
        }
        vBar.setMaximum(cr.height);
        vBar.setThumb(Math.min(cr.height, hr.height));
        int vs = vBar.getSelection();
        if (vs >= cr.height - hr.height) {
            if (cr.height <= hr.height) {
                vs = 0;
                vBar.setSelection(0);
            }
            cr.y = -vs;
        }
        if (vBar.getThumb() >= vBar.getMaximum()) {
            vBar.setVisible(false);
        } else {
            vBar.setVisible(true);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (this.viewport == null) {
            return super.computeSize(wHint, hHint, changed);
        }
        if (wHint > 16) {
            wHint -= 16;
        }
        Point size = this.viewport.computeSize(wHint, hHint, changed);
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    public static void scrollToVisible(Control control, Rectangle r) {
        int down;
        int y = r == null ? 0 : r.y;
        Rectangle pr = control.getBounds();
        y += pr.y;
        Composite parent = control.getParent();
        while (parent != null && !(parent instanceof Viewport)) {
            pr = parent.getBounds();
            y += pr.y;
            parent = parent.getParent();
        }
        if (parent == null) {
            return;
        }
        Viewport v = (Viewport)parent;
        pr = v.getBounds();
        ScrolledComposite sc = (ScrolledComposite)v.getParent();
        int viewportH = pr.height;
        int availableH = sc.getBounds().height;
        if (viewportH <= availableH) {
            return;
        }
        ScrollBar bar = sc.getVerticalBar();
        int dh = r == null ? 10 : r.height;
        int up = dh + 2 - y;
        if (up > (down = availableH - dh - 2 - dh - y)) {
            up = (up + down) / 2 - 5;
            down = up + 10;
        }
        int delta = 0;
        if (pr.y > down) {
            delta = down - pr.y;
        } else if (pr.y < up) {
            delta = up - pr.y;
        }
        int sDelta = (bar.getMaximum() - bar.getMinimum() - bar.getThumb()) * -delta / (viewportH - availableH);
        bar.setSelection(bar.getSelection() + sDelta);
        pr.y += delta;
        v.setBounds(pr);
        v.layout(true);
    }
}

