/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.wizards.standard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.common.meta.action.XAttributeData;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.WizardDataValidator;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.attribute.XAttributeSupport;
import org.jboss.tools.common.model.ui.wizards.standard.DefaultStandardWizard;

public class DefaultStandardStep
extends WizardPage
implements PropertyChangeListener {
    protected DefaultStandardWizard wizard;
    protected SpecialWizardSupport support;
    protected int id;
    protected XAttributeSupport attributes = new XAttributeSupport();
    boolean isDataChanged = false;
    protected Composite stepControl = null;
    protected WizardDataValidator validator;
    protected boolean isNextEnabled = true;
    boolean loading = false;

    public DefaultStandardStep(SpecialWizardSupport support, int id) {
        super("");
        this.support = support;
        this.id = id;
        this.validator = support.getValidator(id);
        this.attributes.removePropertyChangeListener(this);
        this.attributes.init(support.getTarget(), support.getEntityData()[id]);
        this.attributes.addPropertyChangeListener(this);
    }

    public void dispose() {
        super.dispose();
        if (this.attributes != null) {
            this.attributes.dispose();
        }
        this.attributes = null;
    }

    public void setWizard(IWizard wizard) {
        super.setWizard(wizard);
        if (wizard instanceof DefaultStandardWizard) {
            this.wizard = (DefaultStandardWizard)wizard;
        }
    }

    public void createControl(Composite parent) {
        this.attributes.removePropertyChangeListener(this);
        this.attributes.init(this.support.getTarget(), this.support.getEntityData()[this.id]);
        this.attributes.addPropertyChangeListener(this);
        this.stepControl = this.attributes.createControl(parent);
        this.loading = true;
        try {
            this.attributes.load();
        }
        finally {
            this.loading = false;
        }
        this.setControl((Control)this.stepControl);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.support.getStepId() > this.id) {
                try {
                    this.support.action(SpecialWizardSupport.BACK);
                }
                catch (XModelException e) {
                    ModelUIPlugin.getPluginLog().logError((Throwable)e);
                }
            }
            this.setTitle(this.support.getSubtitle());
            this.loading = true;
            try {
                this.attributes.load();
            }
            finally {
                this.loading = false;
            }
            this.validateAll();
            String focusAttr = this.support.getFocusAttribute(this.id);
            if (focusAttr != null && this.attributes.getFieldEditorByName(focusAttr) != null) {
                this.attributes.getFieldEditorByName(focusAttr).setFocus();
            }
        }
    }

    private void validateAll() {
        this.attributes.store();
        this.validate();
        this.updateFieldEnablement();
    }

    public void propertyChange(PropertyChangeEvent arg0) {
        if (this.loading) {
            return;
        }
        this.isDataChanged = true;
        this.validateAll();
    }

    public void validate() {
        this.validator = this.support.getValidator(this.id);
        if (this.validator == null) {
            return;
        }
        this.wizard.dataChanged(this.validator, this.attributes.getValues());
        this.setPageComplete(this.computePageComplete());
    }

    private boolean computePageComplete() {
        String[] actions = this.support.getActionNames(this.id);
        boolean b = true;
        int i = 0;
        while (i < actions.length && b) {
            if (actions[i].equals(SpecialWizardSupport.NEXT) && !this.support.isActionEnabled(SpecialWizardSupport.NEXT)) {
                b = false;
            } else if (actions[i].equals(SpecialWizardSupport.FINISH) && !this.support.isActionEnabled(SpecialWizardSupport.FINISH)) {
                b = false;
            }
            ++i;
        }
        return b;
    }

    public boolean isDataChanged() {
        return this.isDataChanged;
    }

    public void updateFieldEnablement() {
        if (this.stepControl == null || this.stepControl.isDisposed()) {
            return;
        }
        Properties p = this.attributes.getValues();
        XAttributeData[] ad = this.support.getEntityData()[this.id].getAttributeData();
        int i = 0;
        while (i < ad.length) {
            String n = ad[i].getAttribute().getName();
            boolean b = this.support.isFieldEditorEnabled(this.id, n, p);
            FieldEditor f = this.attributes.getFieldEditorByName(n);
            if (f != null) {
                f.setEnabled(b, this.stepControl);
            }
            ++i;
        }
    }

    public boolean canFlipToNextPage() {
        if (!this.hasNextButton()) {
            return false;
        }
        return this.isPageComplete() && this.support.isActionEnabled(SpecialWizardSupport.NEXT) && this.isNextEnabled;
    }

    private boolean hasNextButton() {
        String[] actions = this.support.getActionNames(this.id);
        int i = 0;
        while (i < actions.length) {
            if (actions[i].equals(SpecialWizardSupport.NEXT)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void save() {
        if (this.attributes != null) {
            this.attributes.store();
        }
    }

    public void load() {
        if (this.attributes != null) {
            this.attributes.load();
        }
    }
}

